/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.distribution.GeometricDistribution;
import org.apache.commons.math3.random.RandomGenerator;

public class Geometric
implements LGenerativeDistribution<Integer> {
    private Double p;
    private RandomGenerator random;

    public Geometric(@ParameterInfo(name="p", description="the probability of success.") Double p) {
        this.p = p;
    }

    @Override
    @GeneratorInfo(name="Geometric", description="The probability distribution of the number of failures before the first success given a fixed probability of success p, supported on the set { 0, 1, 2, 3, ... }.")
    public Integer sample() {
        GeometricDistribution geom = new GeometricDistribution(this.p.doubleValue());
        return geom.sample();
    }

    @Override
    public double density(Integer i) {
        GeometricDistribution geom = new GeometricDistribution(this.p.doubleValue());
        return geom.probability(i.intValue());
    }

    public Double getP() {
        return this.p;
    }

    public void setP(Double p) {
        this.p = p;
    }

    public String toString() {
        return this.getName();
    }
}

