/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.distribution.LogNormalDistribution;

public class LogNormal
implements LGenerativeDistribution<Double> {
    private Double M;
    private Double S;
    LogNormalDistribution logNormalDistribution;

    public LogNormal(@ParameterInfo(name="meanlog", description="the mean of the distribution on the log scale.") Double M, @ParameterInfo(name="sdlog", description="the standard deviation of the distribution on the log scale.") Double S) {
        this.M = M;
        this.S = S;
    }

    private void setup() {
        this.logNormalDistribution = new LogNormalDistribution(this.M.doubleValue(), this.S.doubleValue());
    }

    @Override
    @GeneratorInfo(name="LogNormal", description="The log-normal probability distribution.")
    public Double sample() {
        return this.logNormalDistribution.sample();
    }

    @Override
    public double logDensity(Double x) {
        return this.logNormalDistribution.logDensity(x.doubleValue());
    }

    public Double getM() {
        return this.M;
    }

    public Double getS() {
        return this.S;
    }

    public void setM(Double m) {
        if (!this.M.equals(m)) {
            this.M = m;
            this.setup();
        }
    }

    public void setS(Double s) {
        if (!this.S.equals(s)) {
            this.S = s;
            this.setup();
        }
    }
}

