/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.distributions.Utils;
import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.random.RandomGenerator;

public class Normal
implements LGenerativeDistribution<Double> {
    private Double mean;
    private Double sd;
    private RandomGenerator random;
    NormalDistribution normalDistribution;

    public Normal(@ParameterInfo(name="mean", description="the mean of the distribution.") Double mean, @ParameterInfo(name="sd", description="the standard deviation of the distribution.") Double sd) {
        this.mean = mean;
        if (mean == null) {
            throw new IllegalArgumentException("The mean value can't be null!");
        }
        this.sd = sd;
        if (sd == null) {
            throw new IllegalArgumentException("The sd value can't be null!");
        }
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="Normal", description="The normal probability distribution.")
    public Double sample() {
        double d = this.mean;
        this.normalDistribution = new NormalDistribution(d, this.sd.doubleValue());
        return this.normalDistribution.sample();
    }

    @Override
    public double density(Double x) {
        return this.normalDistribution.density(x.doubleValue());
    }

    public Double getMean() {
        return this.mean;
    }

    public Double getSd() {
        return this.sd;
    }

    public void setMean(Double mean) {
        this.mean = mean;
    }

    public void setSd(Double sd) {
        this.sd = sd;
    }

    public String toString() {
        return this.getName();
    }
}

