/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.distribution.PoissonDistribution;

public class Poisson
implements LGenerativeDistribution<Integer> {
    private Double lambda;
    PoissonDistribution poissonDistribution;

    public Poisson(@ParameterInfo(name="lambda", description="the expected number of events.") Double lambda) {
        this.lambda = lambda;
        this.constructPoissonDistribution();
    }

    private void constructPoissonDistribution() {
        this.poissonDistribution = new PoissonDistribution(this.lambda.doubleValue());
    }

    @Override
    @GeneratorInfo(name="Poisson", description="The probability distribution of the number of events when the expected number of events is lambda, supported on the set { 0, 1, 2, 3, ... }.")
    public Integer sample() {
        return this.poissonDistribution.sample();
    }

    @Override
    public double density(Integer i) {
        PoissonDistribution poisson = new PoissonDistribution(this.lambda.doubleValue());
        return poisson.probability(i.intValue());
    }

    public Double getLambda() {
        return this.lambda;
    }

    public void setLambda(Double lambda) {
        this.constructPoissonDistribution();
        this.lambda = lambda;
    }

    public String toString() {
        return this.getName();
    }
}

