/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.lightweight.distributions;

import lphy.core.distributions.Utils;
import lphy.core.lightweight.LGenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import org.apache.commons.math3.random.RandomGenerator;

public class Uniform
implements LGenerativeDistribution<Double> {
    private Double lower;
    private Double upper;
    private RandomGenerator random;

    public Uniform(@ParameterInfo(name="lower", description="the lower bound of the uniform distribution.") Double lower, @ParameterInfo(name="upper", description="the upper bound of the uniform distribution.") Double upper) {
        this.lower = lower;
        this.upper = upper;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="Uniform", description="The uniform probability distribution.")
    public Double sample() {
        return this.random.nextDouble() * (this.upper - this.lower) + this.lower;
    }

    @Override
    public double density(Double x) {
        return 1.0 / (this.upper - this.lower);
    }

    public Double getLower() {
        return this.lower;
    }

    public Double getUpper() {
        return this.upper;
    }

    public void setLower(Double lower) {
        this.lower = lower;
    }

    public void setUpper(Double upper) {
        this.upper = upper;
    }

    public String toString() {
        return this.getName();
    }
}

