/*
 * Decompiled with CFR 0.152.
 */
package lphy.doc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lphy.LPhyExtensionFactory;
import lphy.core.lightweight.LGenerativeDistribution;
import lphy.core.lightweight.LGenerator;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.MethodInfo;
import lphy.parser.ParserUtils;
import net.steppschuh.markdowngenerator.link.Link;
import net.steppschuh.markdowngenerator.list.UnorderedList;
import net.steppschuh.markdowngenerator.text.Text;
import net.steppschuh.markdowngenerator.text.emphasis.BoldText;
import net.steppschuh.markdowngenerator.text.heading.Heading;

public class GenerateDocs {
    public static void main(String[] args) throws IOException {
        String version = "";
        if (args.length > 0) {
            version = args[0];
        }
        LPhyExtensionFactory factory = LPhyExtensionFactory.getInstance();
        String extName = "LPhy";
        if (args.length > 2) {
            extName = args[1];
            String clsName = args[2];
            factory.loadExtension(clsName);
        }
        System.out.println("Creating doc for " + extName + " ...\n");
        List<Class<GenerativeDistribution>> generativeDistributions = ParserUtils.getGenerativeDistributions();
        generativeDistributions.sort(Comparator.comparing(Class::getSimpleName));
        List<Class<DeterministicFunction>> functions = ParserUtils.getDeterministicFunctions();
        functions.sort(Comparator.comparing(Class::getSimpleName));
        functions.sort(Comparator.comparing(Class::getSimpleName));
        Path dir = Paths.get(System.getProperty("user.dir"), new String[0]);
        System.out.println("Creating " + extName + " docs to " + dir + "\n");
        String indexMD = GenerateDocs.generateIndex(generativeDistributions, functions, ParserUtils.types, dir, version, extName);
        File f = new File(dir.toString(), "index.md");
        FileWriter writer = new FileWriter(f);
        writer.write(indexMD);
        writer.close();
    }

    private static String generateIndex(List<Class<GenerativeDistribution>> generativeDistributions, List<Class<DeterministicFunction>> functions, Set<Class<?>> types, Path dir, String version, String extName) throws IOException {
        StringBuilder builder = new StringBuilder();
        String h1 = extName + " Language Reference";
        if (version != null || !version.trim().isEmpty()) {
            h1 = h1 + " (version " + version + ")";
        }
        builder.append(new Heading((Object)h1, 1)).append("\n");
        builder.append(new Text((Object)"This an automatically generated language reference of the LinguaPhylo (LPhy) statistical phylogenetic modeling language."));
        builder.append("\n\n");
        builder.append(new Heading((Object)"Generative distributions", 2)).append("\n");
        ArrayList<Link> genDistLinks = new ArrayList<Link>();
        TreeSet<String> names = new TreeSet<String>();
        File file = new File(dir.toString(), "distributions");
        if (!file.exists()) {
            file.mkdir();
        }
        for (Class<GenerativeDistribution> genDist : generativeDistributions) {
            String name = Generator.getGeneratorName(genDist);
            String string = "distributions/" + (String)name + ".md";
            if (names.contains(name)) continue;
            genDistLinks.add(new Link((Object)name, string));
            names.add(name);
            FileWriter writer = new FileWriter(new File(dir.toString(), string));
            GenerateDocs.generateGenerativeDistributions(writer, name, generativeDistributions.stream().filter(o -> Generator.getGeneratorName(o).equals(name)).collect(Collectors.toList()));
            writer.close();
        }
        builder.append(new UnorderedList(genDistLinks)).append("\n\n");
        builder.append(new Heading((Object)"Functions", 2)).append("\n");
        ArrayList<Link> functionLinks = new ArrayList<Link>();
        TreeSet<String> funcNames = new TreeSet<String>();
        file = new File(dir.toString(), "functions");
        if (!file.exists()) {
            file.mkdir();
        }
        for (Class clazz : functions) {
            String name = Generator.getGeneratorName(clazz);
            String fileURL = "functions/" + name + ".md";
            if (funcNames.contains(name)) continue;
            functionLinks.add(new Link((Object)name, fileURL));
            funcNames.add(name);
            FileWriter writer = new FileWriter(new File(dir.toString(), fileURL));
            GenerateDocs.generateFunctions(writer, name, functions.stream().filter(o -> Generator.getGeneratorName(o).equals(name)).collect(Collectors.toList()));
            writer.close();
        }
        builder.append(new UnorderedList(functionLinks)).append("\n\n");
        builder.append(new Heading((Object)"Types", 2)).append("\n");
        ArrayList<Link> typeLinks = new ArrayList<Link>();
        TreeSet<String> treeSet = new TreeSet<String>();
        file = new File(dir.toString(), "types");
        if (!file.exists()) {
            file.mkdir();
        }
        for (Class<?> type : types) {
            String name = type.getSimpleName();
            String fileURL = "types/" + name + ".md";
            if (treeSet.contains(name)) continue;
            typeLinks.add(new Link((Object)name, fileURL));
            treeSet.add(name);
            FileWriter writer = new FileWriter(new File(dir.toString(), fileURL));
            writer.write(GenerateDocs.generateType(type));
            writer.close();
        }
        builder.append(new UnorderedList(typeLinks)).append("\n\n");
        return builder.toString();
    }

    private static String generateType(Class<?> type) {
        StringBuilder builder = new StringBuilder();
        builder.append(new Heading((Object)type.getSimpleName(), 1)).append("\n");
        TreeMap<String, MethodInfo> methodInfoTreeMap = new TreeMap<String, MethodInfo>();
        for (Method method : type.getMethods()) {
            MethodInfo methodInfo = method.getAnnotation(MethodInfo.class);
            if (methodInfo == null) continue;
            methodInfoTreeMap.put(method.getName(), methodInfo);
        }
        if (methodInfoTreeMap.size() > 0) {
            builder.append(new Heading((Object)"Methods", 2)).append("\n\n");
            ArrayList<CallSite> methodText = new ArrayList<CallSite>();
            for (Map.Entry methodInfoEntry : methodInfoTreeMap.entrySet()) {
                methodText.add((CallSite)((Object)(new BoldText(methodInfoEntry.getKey()) + "\n  - " + ((MethodInfo)methodInfoEntry.getValue()).description())));
            }
            builder.append(new UnorderedList(methodText));
        }
        return builder.toString();
    }

    private static void generateGenerativeDistributions(FileWriter writer, String name, List<Class<?>> classes) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(new Heading((Object)(name + " distribution"), 1)).append("\n");
        for (Class<?> c : classes) {
            if (LGenerator.class.isAssignableFrom(c)) {
                builder.append(LGenerativeDistribution.getLightweightGeneratorMarkdown(c)).append("\n\n");
                continue;
            }
            builder.append(Generator.getGeneratorMarkdown(c)).append("\n\n");
        }
        writer.write(builder.toString());
    }

    private static void generateFunctions(FileWriter writer, String name, List<Class<DeterministicFunction>> classes) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(new Heading((Object)(name + " function"), 1)).append("\n");
        for (Class<DeterministicFunction> c : classes) {
            builder.append(Generator.getGeneratorMarkdown(c)).append("\n\n");
        }
        writer.write(builder.toString());
    }
}

