/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import lphy.evolution.Taxa;
import lphy.evolution.TaxaData;
import lphy.evolution.Taxon;
import lphy.evolution.alignment.Alignment;
import lphy.evolution.alignment.SimpleAlignment;
import lphy.evolution.datatype.Standard;
import lphy.evolution.datatype.StandardState;

public class ExtractStringMetaData
implements TaxaData<String> {
    String label;
    String separator;
    int fieldIndex;

    public ExtractStringMetaData(String label, String fieldSeparator, int fieldIndex) {
        this.label = label;
        this.separator = fieldSeparator;
        this.fieldIndex = fieldIndex;
    }

    @Override
    public String getName() {
        return this.label;
    }

    @Override
    public List<String> getData(Taxa taxa) {
        ArrayList<String> list = new ArrayList<String>();
        for (Taxon t : taxa.getTaxonArray()) {
            String[] fields = t.getName().split(Pattern.quote(this.separator));
            if (fields.length <= this.fieldIndex) {
                throw new IllegalArgumentException("Cannot find " + this.fieldIndex + "th element after splitting name " + t + " by substring " + this.separator + " !");
            }
            list.add(fields[this.fieldIndex]);
        }
        return list;
    }

    @Override
    public Alignment extractTraitAlignment(Taxa taxa) {
        List<String> traitList = this.getData(taxa);
        LinkedHashSet<String> uniqTraitVal = new LinkedHashSet<String>(traitList);
        ArrayList<String> uniqueTraits = new ArrayList<String>(uniqTraitVal);
        Standard standard = new Standard(uniqueTraits);
        SimpleAlignment traitAl = new SimpleAlignment(taxa, 1, (SequenceType)standard);
        for (int t = 0; t < traitList.size(); ++t) {
            StandardState state = standard.getStateFromName(traitList.get(t));
            int demeIndex = ((State)Objects.requireNonNull(state)).getIndex();
            traitAl.setState(t, 0, demeIndex);
        }
        return traitAl;
    }
}

