/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution;

import java.util.ArrayList;
import java.util.Map;
import lphy.evolution.Taxon;
import lphy.evolution.tree.TimeTreeNode;
import lphy.graphicalModel.MethodInfo;
import lphy.graphicalModel.MultiDimensional;

public interface Taxa
extends MultiDimensional {
    @MethodInfo(description="The names of the taxa.")
    default public String[] taxaNames() {
        return this.getTaxaNames();
    }

    @MethodInfo(description="gets the ages of these taxa as an array of doubles.")
    default public Double[] ages() {
        return this.getAges();
    }

    @MethodInfo(description="gets the number of taxa.")
    default public int length() {
        return this.ntaxa();
    }

    @MethodInfo(description="the total number of nodes (left + internal) in a binary tree with these taxa.")
    default public int nodeCount() {
        return 2 * this.ntaxa() - 1;
    }

    public int ntaxa();

    default public Taxon getTaxon(int i) {
        return new Taxon("" + i, 0.0);
    }

    default public Taxon[] getTaxonArray() {
        Taxon[] taxa = new Taxon[this.ntaxa()];
        for (int i = 0; i < taxa.length; ++i) {
            taxa[i] = this.getTaxon(i);
        }
        return taxa;
    }

    default public Taxon[] extantTaxa() {
        ArrayList<Taxon> taxonList = new ArrayList<Taxon>();
        for (Taxon taxon : this.getTaxonArray()) {
            if (!taxon.isExtant()) continue;
            taxonList.add(taxon);
        }
        return taxonList.toArray(new Taxon[0]);
    }

    default public String[] getTaxaNames() {
        String[] taxaNames = new String[this.ntaxa()];
        Taxon[] taxa = this.getTaxonArray();
        for (int i = 0; i < this.ntaxa(); ++i) {
            taxaNames[i] = taxa[i].getName();
        }
        return taxaNames;
    }

    default public String[] getSpecies() {
        Taxon[] taxa = this.getTaxonArray();
        String[] species = new String[this.ntaxa()];
        for (int i = 0; i < this.ntaxa(); ++i) {
            species[i] = taxa[i].getSpecies();
        }
        return species;
    }

    default public Double[] getAges() {
        Taxon[] taxa = this.getTaxonArray();
        Double[] ages = new Double[this.ntaxa()];
        for (int i = 0; i < this.ntaxa(); ++i) {
            ages[i] = taxa[i].getAge();
        }
        return ages;
    }

    default public double getAge(String taxonName) {
        Taxon[] taxa = this.getTaxonArray();
        int index = this.indexOfTaxon(taxonName);
        if (index >= 0) {
            return taxa[index].getAge();
        }
        throw new IllegalArgumentException("Taxon named " + taxonName + " not found");
    }

    default public int indexOfTaxon(String taxon) {
        String[] names = this.getTaxaNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(taxon)) continue;
            return i;
        }
        return -1;
    }

    default public boolean isUltrametric() {
        Double[] ages = this.getAges();
        for (int i = 1; i < ages.length; ++i) {
            if (ages[i].equals(ages[0])) continue;
            return false;
        }
        return true;
    }

    @Override
    default public int getDimension() {
        return this.ntaxa();
    }

    public static Taxa createTaxa(int n) {
        Taxon[] taxa = new Taxon[n];
        for (int i = 0; i < taxa.length; ++i) {
            taxa[i] = new Taxon("" + i, 0.0);
        }
        return new Simple(taxa);
    }

    public static Taxa createTaxa(Taxon[] taxa) {
        return new Simple(taxa);
    }

    public static Taxa createTaxa(Double[] ages) {
        Taxon[] taxa = new Taxon[ages.length];
        for (int i = 0; i < taxa.length; ++i) {
            taxa[i] = new Taxon("" + i, ages[i]);
        }
        return new Simple(taxa);
    }

    public static Taxa createTaxa(Object[] objects) {
        Taxon[] taxa = new Taxon[objects.length];
        for (int i = 0; i < taxa.length; ++i) {
            taxa[i] = new Taxon(objects[i].toString(), 0.0);
        }
        return new Simple(taxa);
    }

    public static Taxa createTaxa(TimeTreeNode root) {
        Taxon[] taxa = new Taxon[root.countLeaves()];
        Taxa.collectTaxon(root, taxa);
        return new Simple(taxa);
    }

    public static void collectTaxon(TimeTreeNode node, Taxon[] taxa) {
        if (node.isLeaf()) {
            taxa[node.getIndex()] = new Taxon(node.getId(), node.getAge());
        } else {
            for (TimeTreeNode child : node.getChildren()) {
                Taxa.collectTaxon(child, taxa);
            }
        }
    }

    public static Taxa createTaxa(Map<String, Integer> idMap) {
        Taxon[] taxa = new Taxon[idMap.size()];
        for (Map.Entry<String, Integer> entry : idMap.entrySet()) {
            taxa[entry.getValue().intValue()] = new Taxon(entry.getKey());
        }
        return new Simple(taxa);
    }

    public static class Simple
    implements Taxa {
        Taxon[] taxa;

        public Simple(Taxon[] taxa) {
            this.taxa = taxa;
        }

        @Override
        public int ntaxa() {
            return this.taxa.length;
        }

        @Override
        public Taxon getTaxon(int i) {
            return this.taxa[i];
        }
    }
}

