/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution;

public class Taxon {
    private final String name;
    private String species;
    private double age;

    public Taxon(String name) {
        this(name, null, 0.0);
    }

    public Taxon(String name, double age) {
        this(name, null, age);
    }

    public Taxon(String name, String species) {
        this(name, species, 0.0);
    }

    public Taxon(String name, String species, double age) {
        this.name = name;
        this.species = species;
        this.age = age;
    }

    public final boolean isExtant() {
        return this.age == 0.0;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public void setAge(double age) {
        this.age = age;
    }

    public double getAge() {
        return this.age;
    }

    public String getName() {
        return this.name;
    }

    public String getSpecies() {
        if (this.species == null) {
            return this.name;
        }
        return this.species;
    }

    public String toString() {
        return this.name + (String)(this.species != null && !this.species.equals(this.name) ? "/" + this.species : "") + "=" + this.age;
    }
}

