/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.alignment;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import jebl.evolution.sequences.SequenceType;
import lphy.evolution.Taxa;
import lphy.evolution.Taxon;
import lphy.evolution.alignment.Alignment;
import lphy.graphicalModel.MethodInfo;

public abstract class AbstractAlignment
implements Alignment {
    protected int nchar;
    protected Taxa taxa;
    final SequenceType sequenceType;

    public AbstractAlignment(Map<String, Integer> idMap, int nchar, SequenceType sequenceType) {
        this.taxa = Taxa.createTaxa(idMap);
        this.nchar = nchar;
        this.sequenceType = sequenceType;
    }

    public AbstractAlignment(Taxa taxa, int nchar, SequenceType sequenceType) {
        this.taxa = taxa;
        this.nchar = nchar;
        this.sequenceType = sequenceType;
    }

    public AbstractAlignment(int nchar, Alignment source) {
        this.nchar = nchar;
        this.taxa = Taxa.createTaxa(Arrays.copyOf(source.getTaxa().getTaxonArray(), source.ntaxa()));
        this.sequenceType = source.getSequenceType();
    }

    public AbstractAlignment(AbstractAlignment source) {
        this(Objects.requireNonNull(source).nchar(), source);
    }

    @Override
    @MethodInfo(description="The number of characters/sites.", narrativeName="number of characters")
    public Integer nchar() {
        return this.nchar;
    }

    @Override
    @MethodInfo(description="The names of the taxa.")
    public String[] getTaxaNames() {
        return this.taxa.getTaxaNames();
    }

    @Override
    @MethodInfo(description="the taxa of the alignment.", narrativeName="list of taxa")
    public Taxa taxa() {
        return this.getTaxa();
    }

    @Override
    public int ntaxa() {
        return this.taxa.ntaxa();
    }

    @Override
    public Taxon getTaxon(int taxonIndex) {
        return this.taxa.getTaxon(taxonIndex);
    }

    @Override
    public String getTaxonName(int taxonIndex) {
        return this.getTaxon(taxonIndex).getName();
    }

    @Override
    public Taxon[] getTaxonArray() {
        return this.taxa.getTaxonArray();
    }

    @Override
    public Taxa getTaxa() {
        return this.taxa;
    }

    public String toString() {
        return this.sequenceType.getName() + " alignment " + this.ntaxa() + " by " + this.nchar;
    }

    @Override
    public SequenceType getSequenceType() {
        return Objects.requireNonNull(this.sequenceType);
    }

    @Override
    public int getDimension() {
        return this.ntaxa();
    }
}

