/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.alignment;

import java.util.Objects;
import jebl.evolution.sequences.SequenceType;
import lphy.evolution.Taxa;
import lphy.evolution.alignment.TaxaCharacterMatrix;
import lphy.graphicalModel.MethodInfo;

public interface Alignment
extends Taxa,
TaxaCharacterMatrix<Integer> {
    @MethodInfo(description="the taxa of the alignment.", narrativeName="list of taxa")
    default public Taxa taxa() {
        return this.getTaxa();
    }

    @MethodInfo(description="the number of possible states in the alignment.", narrativeName="number of states")
    default public int stateCount() {
        return this.getStateCount();
    }

    @MethodInfo(description="get the data type of this alignment.", narrativeName="data type")
    default public SequenceType dataType() {
        return this.getSequenceType();
    }

    public void setState(int var1, int var2, int var3);

    @Override
    default public Integer getState(String taxon, int position) {
        return this.getState(this.indexOfTaxon(taxon), position);
    }

    public int getState(int var1, int var2);

    public SequenceType getSequenceType();

    default public String getSequenceTypeStr() {
        return Objects.requireNonNull(this.getSequenceType()).getName();
    }

    default public int getCanonicalStateCount() {
        return Objects.requireNonNull(this.getSequenceType()).getCanonicalStateCount();
    }

    default public int getStateCount() {
        return Objects.requireNonNull(this.getSequenceType()).getStateCount();
    }

    @Override
    default public Taxa getTaxa() {
        return this;
    }

    public String getTaxonName(int var1);

    @Override
    default public Class getComponentType() {
        return Integer.class;
    }
}

