/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.alignment;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lphy.evolution.alignment.SimpleAlignment;
import lphy.evolution.tree.TimeTree;
import lphy.graphicalModel.RandomValueLogger;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.nexus.NexusWriter;

public class AlignmentFileLogger
implements RandomValueLogger {
    String name;
    List<FileWriter> fileWriter = new ArrayList<FileWriter>();

    public AlignmentFileLogger(String name) {
        this.name = name;
    }

    @Override
    public void log(int rep, List<Value<?>> values) {
        for (Value<SimpleAlignment> v : this.getAlignmentValues(values)) {
            try {
                this.logAlignment(v, rep);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
        for (FileWriter writer : this.fileWriter) {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void openFiles(List<RandomVariable<TimeTree>> treeVariables) throws IOException {
        for (RandomVariable<TimeTree> tree : treeVariables) {
            String fileName = this.name + "_" + tree.getId() + ".trees";
            this.fileWriter.add(new FileWriter(fileName));
        }
    }

    private List<Value<SimpleAlignment>> getAlignmentValues(List<Value<?>> values) {
        ArrayList<Value<SimpleAlignment>> alignments = new ArrayList<Value<SimpleAlignment>>();
        for (Value<?> v : values) {
            if (!(v.value() instanceof SimpleAlignment)) continue;
            alignments.add(v);
        }
        return alignments;
    }

    private void logAlignment(Value<SimpleAlignment> alignment, int rep) throws IOException {
        String fileName = this.name + "_" + alignment.getId() + "_" + rep + ".nexus";
        PrintStream stream = new PrintStream(fileName);
        try {
            NexusWriter.write(alignment.value(), new LinkedList<TimeTree>(), stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

