/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.alignment;

import java.util.List;
import lphy.evolution.alignment.SimpleAlignment;
import lphy.evolution.traits.CharSetBlock;

public final class AlignmentUtils {
    public static SimpleAlignment getCharSetAlignment(List<CharSetBlock> charSetBlocks, SimpleAlignment parentAlignment) {
        int partNChar = AlignmentUtils.getNCharFromCharSet(charSetBlocks, parentAlignment.nchar());
        SimpleAlignment part = new SimpleAlignment(partNChar, parentAlignment);
        AlignmentUtils.fillSeqsToPartition(charSetBlocks, part, parentAlignment);
        return part;
    }

    private static int getNCharFromCharSet(List<CharSetBlock> charSetBlocks, int nchar) {
        int s = 0;
        for (CharSetBlock block : charSetBlocks) {
            int toSite = block.getTo();
            if (toSite <= 0) {
                toSite = nchar;
            }
            for (int i = block.getFrom(); i <= toSite; i += block.getEvery()) {
                ++s;
            }
        }
        return s;
    }

    private static void fillSeqsToPartition(List<CharSetBlock> charSetBlocks, SimpleAlignment partAlignment, SimpleAlignment parentAlignment) {
        for (int t = 0; t < parentAlignment.ntaxa(); ++t) {
            int pos = 0;
            for (CharSetBlock block : charSetBlocks) {
                int toSite = block.getTo();
                if (toSite <= 0) {
                    toSite = parentAlignment.nchar();
                }
                for (int i = block.getFrom(); i <= toSite; i += block.getEvery()) {
                    int state = parentAlignment.getState(t, i - 1);
                    partAlignment.setState(t, pos, state);
                    ++pos;
                }
            }
            assert (pos == partAlignment.nchar());
        }
    }
}

