/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.alignment;

import java.util.Arrays;
import java.util.Objects;
import lphy.evolution.Taxa;
import lphy.evolution.alignment.TaxaCharacterMatrix;

public class ContinuousCharacterData
implements TaxaCharacterMatrix<Double> {
    Double[][] continuousCharacterData;
    Taxa taxa;

    public ContinuousCharacterData(Taxa taxa, Double[][] continuousCharacterData) {
        this.taxa = taxa;
        this.continuousCharacterData = continuousCharacterData;
    }

    @Override
    public Double getState(String taxonName, int column) {
        return this.continuousCharacterData[this.taxa.indexOfTaxon(taxonName)][column];
    }

    public Double getState(int taxonIndex, int column) {
        return this.continuousCharacterData[taxonIndex][column];
    }

    @Override
    public Class getComponentType() {
        return Double.class;
    }

    @Override
    public Taxa getTaxa() {
        return this.taxa;
    }

    @Override
    public Integer nchar() {
        return this.continuousCharacterData[0].length;
    }

    @Override
    public String toJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (int i = 0; i < Objects.requireNonNull(this.taxa).ntaxa(); ++i) {
            builder.append("  ").append(this.taxa.getTaxon(i));
            builder.append(" = ").append(Arrays.toString(this.continuousCharacterData[i]));
            builder.append(",");
            builder.append("\n");
        }
        builder.append("  ntax = ").append(this.taxa.ntaxa());
        builder.append("\n").append("}");
        return builder.toString();
    }

    @Override
    public int getDimension() {
        return this.nchar() * this.taxa.getDimension();
    }
}

