/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.alignment;

import java.util.SortedMap;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.evolution.alignment.Alignment;
import lphy.evolution.alignment.ErrorAlignment;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.random.RandomGenerator;

public class ErrorModel
implements GenerativeDistribution<Alignment> {
    Value<Double> alpha;
    Value<Double> beta;
    Value<Alignment> alignment;
    public final String alphaParamName = "alpha";
    public final String betaParamName = "beta";
    public final String alignmentParamName = "alignment";
    RandomGenerator random;

    public ErrorModel(@ParameterInfo(name="alpha", description="the false positive probability.") Value<Double> alpha, @ParameterInfo(name="beta", description="the false negative probability.") Value<Double> beta, @ParameterInfo(name="alignment", description="the alignment without errors.") Value<Alignment> alignment) {
        this.alpha = alpha;
        this.beta = beta;
        this.alignment = alignment;
        this.random = Utils.getRandom();
    }

    public SortedMap<String, Value> getParams() {
        TreeMap<String, Value> map = new TreeMap<String, Value>();
        map.put("alpha", this.alpha);
        map.put("beta", this.beta);
        map.put("alignment", this.alignment);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("alpha")) {
            if (!(value.value() instanceof Double)) throw new IllegalArgumentException("Expecting type double, but got " + value.value().getClass());
            this.alpha = value;
            return;
        } else if (paramName.equals("beta")) {
            this.beta = value;
            return;
        } else {
            if (!paramName.equals("alignment")) throw new RuntimeException("Unrecognised parameter name: " + paramName);
            this.alignment = value;
        }
    }

    @Override
    @GeneratorInfo(name="ErrorModel", description="The error model distribution on an alignment.")
    public RandomVariable<Alignment> sample() {
        Alignment original = this.alignment.value();
        ErrorAlignment newAlignment = new ErrorAlignment(original.nchar(), original);
        double a = this.alpha.value();
        double b = this.beta.value();
        for (int i = 0; i < newAlignment.ntaxa(); ++i) {
            for (int j = 0; j < newAlignment.nchar(); ++j) {
                newAlignment.setState(i, j, this.error(original.getState(i, j), a, b));
            }
        }
        return new RandomVariable<Alignment>("D", newAlignment, this);
    }

    private int error(int state, double alpha, double beta) {
        double U = this.random.nextDouble();
        switch (state) {
            case 0: {
                if (U < alpha) {
                    return 1;
                }
                return 0;
            }
        }
        if (U < beta) {
            return 0;
        }
        return 1;
    }
}

