/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.alignment;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import lphy.evolution.Taxa;
import lphy.evolution.alignment.AbstractAlignment;
import lphy.evolution.alignment.Alignment;

public class SimpleAlignment
extends AbstractAlignment {
    int[][] alignment;

    public SimpleAlignment(Map<String, Integer> idMap, int nchar, SequenceType sequenceType) {
        super(idMap, nchar, sequenceType);
        this.alignment = new int[this.ntaxa()][nchar];
    }

    public SimpleAlignment(Taxa taxa, int nchar, SequenceType sequenceType) {
        super(taxa, nchar, sequenceType);
        this.alignment = new int[this.ntaxa()][nchar];
    }

    public SimpleAlignment(int nchar, Alignment source) {
        super(nchar, source);
        this.alignment = new int[this.ntaxa()][nchar];
    }

    @Override
    public void setState(int taxon, int position, int state) {
        if (this.sequenceType == null) {
            throw new IllegalArgumentException("Please define SequenceType, not numStates !");
        }
        if (state < 0 || state > this.getStateCount()) {
            throw new IllegalArgumentException("Illegal to set a " + this.sequenceType.getName() + " state outside of the range [0, " + (this.sequenceType.getStateCount() - 1) + "] ! state = " + state);
        }
        this.alignment[taxon][position] = state;
    }

    public void setState(String taxon, int position, int state) {
        this.setState(this.indexOfTaxon(taxon), position, state);
    }

    @Override
    public int getState(int taxon, int position) {
        return this.alignment[taxon][position];
    }

    @Override
    public String toJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (int i = 0; i < this.ntaxa(); ++i) {
            builder.append("  ").append(this.getTaxonName(i));
            builder.append(" = ").append(Arrays.toString(this.alignment[i]));
            builder.append(",");
            builder.append("\n");
        }
        builder.append("  nchar = ").append(this.nchar);
        builder.append(", ntax = ").append(super.ntaxa());
        if (this.isUltrametric()) {
            builder.append(",\n").append("  ages = ").append(Arrays.toString((Object[])this.getAges()));
        }
        builder.append("\n").append("}");
        return builder.toString();
    }

    public String getSequence(int taxonIndex) {
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < this.alignment[taxonIndex].length; ++j) {
            State state = this.sequenceType.getState(this.alignment[taxonIndex][j]);
            builder.append(Objects.requireNonNull(state));
        }
        return builder.toString();
    }

    @Deprecated
    private char getBinaryChar(int state) {
        if (this.getCanonicalStateCount() != 2) {
            throw new IllegalArgumentException("Binary only have 2 states ! state = " + state);
        }
        return (char)(48 + state);
    }
}

