/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.birthdeath;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.evolution.birthdeath.FullBirthDeathTree;
import lphy.evolution.birthdeath.RhoSampleTree;
import lphy.evolution.tree.TimeTree;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.random.RandomGenerator;

public class BirthDeathSamplingTree
implements GenerativeDistribution<TimeTree> {
    private Value<Number> birthRate;
    private Value<Number> deathRate;
    private Value<Number> rho;
    private Value<Number> rootAge;
    RandomGenerator random;

    public BirthDeathSamplingTree(@ParameterInfo(name="lambda", description="per-lineage birth rate.") Value<Number> birthRate, @ParameterInfo(name="mu", description="per-lineage death rate.") Value<Number> deathRate, @ParameterInfo(name="rho", description="the sampling proportion.") Value<Number> rho, @ParameterInfo(name="rootAge", description="the age of the root of the tree.") Value<Number> rootAge) {
        this.birthRate = birthRate;
        this.deathRate = deathRate;
        this.rho = rho;
        this.rootAge = rootAge;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="BirthDeathSampling", verbClause="is assumed to have evolved according to", narrativeName="birth-death-sampling tree process", description="The Birth-death-sampling tree distribution over tip-labelled time trees.<br>Conditioned on root age.")
    public RandomVariable<TimeTree> sample() {
        FullBirthDeathTree birthDeathTree = new FullBirthDeathTree(this.birthRate, this.deathRate, this.rootAge, null);
        RandomVariable<TimeTree> fullTree = birthDeathTree.sample();
        RhoSampleTree rhoSampleTree = new RhoSampleTree(fullTree, this.rho);
        return rhoSampleTree.sample();
    }

    @Override
    public double logDensity(TimeTree timeTree) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("lambda", BirthDeathSamplingTree.this.birthRate);
                this.put("mu", BirthDeathSamplingTree.this.deathRate);
                this.put("rho", BirthDeathSamplingTree.this.rho);
                this.put("rootAge", BirthDeathSamplingTree.this.rootAge);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "lambda": {
                this.birthRate = value;
                break;
            }
            case "mu": {
                this.deathRate = value;
                break;
            }
            case "rho": {
                this.rho = value;
                break;
            }
            case "rootAge": {
                this.rootAge = value;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised parameter name: " + paramName);
            }
        }
    }

    public String toString() {
        return this.getName();
    }
}

