/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.birthdeath;

import java.util.Map;
import java.util.TreeMap;
import lphy.evolution.birthdeath.BirthDeathSamplingTree;
import lphy.evolution.tree.TimeTree;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;

public class BirthDeathSamplingTreeDT
implements GenerativeDistribution<TimeTree> {
    private Value<Number> diversificationRate;
    private Value<Number> turnover;
    private Value<Number> rho;
    private Value<Number> rootAge;
    BirthDeathSamplingTree wrapped;

    public BirthDeathSamplingTreeDT(@ParameterInfo(name="diversification", narrativeName="diversification rate", description="diversification rate.") Value<Number> diversification, @ParameterInfo(name="turnover", description="turnover.") Value<Number> turnover, @ParameterInfo(name="rho", narrativeName="sampling proportion", description="the sampling proportion.") Value<Number> rho, @ParameterInfo(name="rootAge", narrativeName="root age", description="the age of the root node.") Value<Number> rootAge) {
        this.turnover = turnover;
        this.diversificationRate = diversification;
        this.rho = rho;
        this.rootAge = rootAge;
        this.setup();
    }

    @Override
    @GeneratorInfo(name="BirthDeathSampling", verbClause="is assumed to have evolved according to", narrativeName="birth-death-sampling tree process", description="The Birth-death-sampling tree distribution over tip-labelled time trees.<br>Conditioned on root age.")
    public RandomVariable<TimeTree> sample() {
        this.setup();
        RandomVariable<TimeTree> tree = this.wrapped.sample();
        return new RandomVariable<TimeTree>("\u03c8", (TimeTree)tree.value(), this);
    }

    private void setup() {
        double turno = ValueUtils.doubleValue(this.turnover);
        double divers = ValueUtils.doubleValue(this.diversificationRate);
        double denom = Math.abs(1.0 - turno);
        double birth_rate = divers / denom;
        double death_rate = turno * divers / denom;
        this.wrapped = new BirthDeathSamplingTree(new Value<Number>("birthRate", birth_rate), new Value<Number>("deathRate", death_rate), this.rho, this.rootAge);
    }

    @Override
    public double logDensity(TimeTree timeTree) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("diversification", BirthDeathSamplingTreeDT.this.diversificationRate);
                this.put("turnover", BirthDeathSamplingTreeDT.this.turnover);
                this.put("rho", BirthDeathSamplingTreeDT.this.rho);
                this.put("rootAge", BirthDeathSamplingTreeDT.this.rootAge);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "diversification": {
                this.diversificationRate = value;
                break;
            }
            case "turnover": {
                this.turnover = value;
                break;
            }
            case "rho": {
                this.rho = value;
                break;
            }
            case "rootAge": {
                this.rootAge = value;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised parameter name: " + paramName);
            }
        }
    }

    public Value<Number> getDiversificationRate() {
        return this.diversificationRate;
    }

    public Value<Number> getTurnover() {
        return this.turnover;
    }

    public Value<Number> getRho() {
        return this.rho;
    }

    public Value<Number> getRootAge() {
        return this.rootAge;
    }
}

