/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.birthdeath;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lphy.core.distributions.Utils;
import lphy.evolution.tree.TaxaConditionedTreeGenerator;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;

public class BirthDeathTree
extends TaxaConditionedTreeGenerator {
    private Value<Number> birthRate;
    private Value<Number> deathRate;
    private Value<Number> rootAge;

    public BirthDeathTree(@ParameterInfo(name="lambda", description="per-lineage birth rate.") Value<Number> birthRate, @ParameterInfo(name="mu", description="per-lineage death rate.") Value<Number> deathRate, @ParameterInfo(name="n", description="the number of taxa. optional.", optional=true) Value<Integer> n, @ParameterInfo(name="taxa", description="a string array of taxa id or a taxa object (e.g. dataframe, alignment or tree), optional.", optional=true) Value taxa, @ParameterInfo(name="rootAge", description="the age of the root.") Value<Number> rootAge) {
        super(n, taxa, null);
        this.birthRate = birthRate;
        this.deathRate = deathRate;
        this.rootAge = rootAge;
        this.random = Utils.getRandom();
        this.checkTaxaParameters(true);
    }

    @Override
    @GeneratorInfo(name="BirthDeath", description="A tree of only extant species, which is conceptually embedded in a full species tree produced by a speciation-extinction (birth-death) branching process.<br>Conditioned on root age and on number of taxa.")
    public RandomVariable<TimeTree> sample() {
        int i;
        TimeTree tree = new TimeTree(this.getTaxa());
        List<TimeTreeNode> activeNodes = this.createLeafTaxa(tree);
        double lambda = ValueUtils.doubleValue(this.birthRate);
        double mu = ValueUtils.doubleValue(this.deathRate);
        double t = ValueUtils.doubleValue(this.rootAge);
        double[] times = new double[activeNodes.size() - 1];
        for (i = 0; i < times.length - 1; ++i) {
            times[i] = this.birthDeathInternalQ(this.random.nextDouble(), lambda, mu, t);
        }
        times[times.length - 1] = t;
        Arrays.sort(times);
        for (i = 0; i < times.length; ++i) {
            TimeTreeNode a = this.drawRandomNode(activeNodes);
            TimeTreeNode b = this.drawRandomNode(activeNodes);
            TimeTreeNode parent = new TimeTreeNode(times[i], new TimeTreeNode[]{a, b});
            activeNodes.add(parent);
        }
        tree.setRoot(activeNodes.get(0));
        return new RandomVariable<TimeTree>("\u03c8", tree, this);
    }

    private double birthDeathInternalQ(double p, double lambda, double mu, double rootHeight) {
        if (lambda == mu) {
            return p * rootHeight / (1.0 + lambda * rootHeight * (1.0 - p));
        }
        double h = lambda - mu;
        double e1 = Math.exp(-h * rootHeight);
        double a1 = lambda - mu * e1;
        double a2 = p * (1.0 - e1);
        return 1.0 / h * Math.log((a1 - mu * a2) / (a1 - lambda * a2));
    }

    @Override
    public double logDensity(TimeTree timeTree) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public Map<String, Value> getParams() {
        Map<String, Value> map = super.getParams();
        map.put("lambda", this.birthRate);
        map.put("mu", this.deathRate);
        map.put("rootAge", this.rootAge);
        return map;
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "lambda": {
                this.birthRate = value;
                break;
            }
            case "mu": {
                this.deathRate = value;
                break;
            }
            case "rootAge": {
                this.rootAge = value;
                break;
            }
            default: {
                super.setParam(paramName, value);
            }
        }
    }
}

