/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.birthdeath;

import java.util.Map;
import java.util.TreeMap;
import lphy.evolution.birthdeath.FullBirthDeathTree;
import lphy.evolution.tree.TimeTree;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;

public class BirthDeathTreeDT
implements GenerativeDistribution<TimeTree> {
    private Value<Number> diversificationRate;
    private Value<Number> turnover;
    private Value<Number> rootAge;
    FullBirthDeathTree wrapped;

    public BirthDeathTreeDT(@ParameterInfo(name="diversification", description="diversification rate.") Value<Number> diversification, @ParameterInfo(name="turnover", description="turnover.") Value<Number> turnover, @ParameterInfo(name="rootAge", description="the number of taxa.") Value<Number> rootAge) {
        this.turnover = turnover;
        this.diversificationRate = diversification;
        this.rootAge = rootAge;
        this.setup();
    }

    @Override
    @GeneratorInfo(name="BirthDeath", description="The Birth-death-sampling tree distribution over tip-labelled time trees.<br>Conditioned on root age.")
    public RandomVariable<TimeTree> sample() {
        this.setup();
        RandomVariable<TimeTree> tree = this.wrapped.sample();
        return new RandomVariable<TimeTree>("\u03c8", (TimeTree)tree.value(), this);
    }

    private void setup() {
        double turno = ValueUtils.doubleValue(this.turnover);
        double divers = ValueUtils.doubleValue(this.diversificationRate);
        double denom = Math.abs(1.0 - turno);
        double birth_rate = divers / denom;
        double death_rate = turno * divers / denom;
        this.wrapped = new FullBirthDeathTree(new Value<Number>("lambda", birth_rate), new Value<Number>("mu", death_rate), this.rootAge, null);
    }

    @Override
    public double logDensity(TimeTree timeTree) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("diversification", BirthDeathTreeDT.this.diversificationRate);
                this.put("turnover", BirthDeathTreeDT.this.turnover);
                this.put("rootAge", BirthDeathTreeDT.this.rootAge);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "diversification": {
                this.diversificationRate = value;
                break;
            }
            case "turnover": {
                this.turnover = value;
                break;
            }
            case "rootAge": {
                this.rootAge = value;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised parameter name: " + paramName);
            }
        }
    }

    public String toString() {
        return this.getName();
    }
}

