/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.birthdeath;

import java.util.Map;
import lphy.core.distributions.Utils;
import lphy.evolution.Taxa;
import lphy.evolution.birthdeath.SimBDReverse;
import lphy.evolution.birthdeath.SimFossilsPoisson;
import lphy.evolution.tree.PruneTree;
import lphy.evolution.tree.TaxaConditionedTreeGenerator;
import lphy.evolution.tree.TimeTree;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;

public class FossilBirthDeathTree
extends TaxaConditionedTreeGenerator {
    private Value<Number> birthRate;
    private Value<Number> deathRate;
    private Value<Number> psiVal;
    private Value<Number> rhoVal;

    public FossilBirthDeathTree(@ParameterInfo(name="lambda", description="per-lineage birth rate.") Value<Number> birthRate, @ParameterInfo(name="mu", description="per-lineage death rate.") Value<Number> deathRate, @ParameterInfo(name="rho", description="proportion of extant taxa sampled.") Value<Number> rhoVal, @ParameterInfo(name="psi", description="per-lineage sampling-through-time rate.") Value<Number> psiVal, @ParameterInfo(name="n", description="the number of taxa. optional.", optional=true) Value<Integer> n, @ParameterInfo(name="taxa", description="Taxa object", optional=true) Value<Taxa> taxa) {
        super(n, taxa, null);
        this.birthRate = birthRate;
        this.deathRate = deathRate;
        this.rhoVal = rhoVal;
        this.psiVal = psiVal;
        this.random = Utils.getRandom();
        this.checkTaxaParameters(false);
    }

    @Override
    @GeneratorInfo(name="FossilBirthDeathTree", description="A tree of extant species and those sampled through time, which is conceptually embedded in a full species tree produced by a speciation-extinction (birth-death) branching process.<br>Conditioned on root age and (optionally) on number of *extant* taxa.")
    public RandomVariable<TimeTree> sample() {
        SimBDReverse simBDReverse = new SimBDReverse(this.birthRate, this.deathRate, this.taxaValue, this.rhoVal);
        RandomVariable<TimeTree> bdReverseTree = simBDReverse.sample();
        SimFossilsPoisson simFossilsPoisson = new SimFossilsPoisson(bdReverseTree, this.psiVal);
        RandomVariable<TimeTree> fullTreeWithFossils = simFossilsPoisson.sample();
        PruneTree pruneTree = new PruneTree(fullTreeWithFossils);
        TimeTree tree = pruneTree.apply().value();
        return new RandomVariable<TimeTree>(null, tree, this);
    }

    @Override
    public double logDensity(TimeTree timeTree) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public Map<String, Value> getParams() {
        Map<String, Value> map = super.getParams();
        map.put("lambda", this.birthRate);
        map.put("mu", this.deathRate);
        map.put("rho", this.rhoVal);
        map.put("psi", this.psiVal);
        return map;
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "lambda": {
                this.birthRate = value;
                break;
            }
            case "mu": {
                this.deathRate = value;
                break;
            }
            case "rho": {
                this.rhoVal = value;
                break;
            }
            case "psi": {
                this.psiVal = value;
                break;
            }
            default: {
                super.setParam(paramName, value);
            }
        }
    }

    public Value<Number> getBirthRate() {
        return this.birthRate;
    }

    public Value<Number> getDeathRate() {
        return this.deathRate;
    }

    public Value<Number> getRho() {
        return this.rhoVal;
    }

    public Value<Number> getPsi() {
        return this.psiVal;
    }
}

