/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.birthdeath;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.random.RandomGenerator;

public class FullBirthDeathTree
implements GenerativeDistribution<TimeTree> {
    private Value<Number> birthRate;
    private Value<Number> deathRate;
    private Value<Number> rootAge;
    private Value<Number> originAge;
    private List<TimeTreeNode> activeNodes;
    RandomGenerator random;
    private static final int MAX_ATTEMPTS = 1000;

    public FullBirthDeathTree(@ParameterInfo(name="lambda", description="per-lineage birth rate.") Value<Number> birthRate, @ParameterInfo(name="mu", description="per-lineage death rate.") Value<Number> deathRate, @ParameterInfo(name="rootAge", description="the age of the root of the tree (only one of rootAge and originAge may be specified).", optional=true) Value<Number> rootAge, @ParameterInfo(name="originAge", description="the age of the origin of the tree  (only one of rootAge and originAge may be specified).", optional=true) Value<Number> originAge) {
        this.birthRate = birthRate;
        this.deathRate = deathRate;
        this.rootAge = rootAge;
        this.originAge = originAge;
        this.random = Utils.getRandom();
        if (rootAge != null && originAge != null) {
            throw new IllegalArgumentException("Only one of rootAge and originAge may be specified!");
        }
        if (rootAge == null && originAge == null) {
            throw new IllegalArgumentException("One of rootAge and originAge must be specified!");
        }
        this.activeNodes = new ArrayList<TimeTreeNode>();
    }

    @Override
    @GeneratorInfo(name="FullBirthDeath", description="A birth-death tree with both extant and extinct species.<br>Conditioned on age of root or origin.")
    public RandomVariable<TimeTree> sample() {
        boolean success = false;
        TimeTree tree = new TimeTree();
        TimeTreeNode root = null;
        double lambda = ValueUtils.doubleValue(this.birthRate);
        double mu = ValueUtils.doubleValue(this.deathRate);
        for (int attempts = 0; !success && attempts < 1000; ++attempts) {
            this.activeNodes.clear();
            root = new TimeTreeNode((String)null, tree);
            if (this.rootAge != null) {
                root.setAge(ValueUtils.doubleValue(this.rootAge));
            } else {
                root.setAge(ValueUtils.doubleValue(this.originAge));
            }
            double time = root.getAge();
            if (this.rootAge != null) {
                this.activeNodes.add(root);
                this.doBirth(this.activeNodes, time, tree);
            } else {
                TimeTreeNode origin = root;
                root = new TimeTreeNode((String)null, tree);
                root.setAge(origin.getAge());
                origin.addChild(root);
                this.activeNodes.add(root);
                root = root.getParent();
            }
            while (time > 0.0 && this.activeNodes.size() > 0) {
                int k = this.activeNodes.size();
                double totalRate = (lambda + mu) * (double)k;
                double x = -Math.log(this.random.nextDouble()) / totalRate;
                if ((time -= x) < 0.0) break;
                double U = this.random.nextDouble();
                if (U < lambda / (lambda + mu)) {
                    this.doBirth(this.activeNodes, time, tree);
                    continue;
                }
                this.doDeath(this.activeNodes, time);
            }
            int number = 0;
            for (TimeTreeNode node : this.activeNodes) {
                node.setAge(0.0);
                node.setId("" + number);
                ++number;
            }
            success = this.activeNodes.size() > 0;
        }
        if (!success) {
            throw new RuntimeException("Failed to simulated FullBirthDeathTree after 1000 attempts.");
        }
        tree.setRoot(root, true);
        return new RandomVariable<TimeTree>(null, tree, this);
    }

    private void doBirth(List<TimeTreeNode> activeNodes, double age, TimeTree tree) {
        TimeTreeNode parent = activeNodes.remove(this.random.nextInt(activeNodes.size()));
        parent.setAge(age);
        TimeTreeNode child1 = new TimeTreeNode((String)null, tree);
        TimeTreeNode child2 = new TimeTreeNode((String)null, tree);
        child1.setAge(age);
        child2.setAge(age);
        parent.addChild(child1);
        parent.addChild(child2);
        activeNodes.add(child1);
        activeNodes.add(child2);
    }

    private void doDeath(List<TimeTreeNode> activeNodes, double age) {
        TimeTreeNode deadNode = activeNodes.remove(this.random.nextInt(activeNodes.size()));
        deadNode.setAge(age);
    }

    @Override
    public double logDensity(TimeTree timeTree) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("lambda", FullBirthDeathTree.this.birthRate);
                this.put("mu", FullBirthDeathTree.this.deathRate);
                if (FullBirthDeathTree.this.rootAge != null) {
                    this.put("rootAge", FullBirthDeathTree.this.rootAge);
                }
                if (FullBirthDeathTree.this.originAge != null) {
                    this.put("originAge", FullBirthDeathTree.this.originAge);
                }
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("lambda")) {
            this.birthRate = value;
        } else if (paramName.equals("mu")) {
            this.deathRate = value;
        } else if (paramName.equals("rootAge")) {
            this.rootAge = value;
        } else if (paramName.equals("originAge")) {
            this.originAge = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public String toString() {
        return this.getName();
    }
}

