/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.birthdeath;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.evolution.tree.TimeTreeUtils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.random.RandomGenerator;

public class RhoSampleTree
implements GenerativeDistribution<TimeTree> {
    private Value<TimeTree> tree;
    private Value<Number> rho;
    RandomGenerator random;

    public RhoSampleTree(@ParameterInfo(name="tree", description="the full tree to sample") Value<TimeTree> tree, @ParameterInfo(name="rho", description="the probability that each tip at time zero is sampled") Value<Number> rho) {
        this.tree = tree;
        this.rho = rho;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="RhoSampleTree", description="A tree sampled from a larger tree by selecting tips at time zero with probability rho.<br>Conditioned on root age.")
    public RandomVariable<TimeTree> sample() {
        TimeTree sampleTree = new TimeTree(this.tree.value());
        double p = ValueUtils.doubleValue(this.rho);
        ArrayList<TimeTreeNode> sampleTips = new ArrayList<TimeTreeNode>();
        while (sampleTips.size() == 0) {
            for (TimeTreeNode node : sampleTree.getNodes()) {
                if (!node.isLeaf() || node.getAge() != 0.0 || !(this.random.nextDouble() < p)) continue;
                sampleTips.add(node);
            }
        }
        System.out.println("Sample tree has " + sampleTips.size() + " tips.");
        for (TimeTreeNode tip : sampleTips) {
            TimeTreeUtils.markNodeAndDirectAncestors(tip);
        }
        TimeTreeUtils.removeUnmarkedNodes(sampleTree);
        TimeTreeNode newRoot = TimeTreeUtils.getFirstNonSingleChildNode(sampleTree);
        if (!newRoot.isRoot()) {
            newRoot.getParent().removeChild(newRoot);
        }
        TimeTreeUtils.removeSingleChildNodes(newRoot, true);
        sampleTree.setRoot(newRoot, true);
        return new RandomVariable<TimeTree>("\u03c8", sampleTree, this);
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("tree", RhoSampleTree.this.tree);
                this.put("rho", RhoSampleTree.this.rho);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("tree")) {
            this.tree = value;
        } else if (paramName.equals("rho")) {
            this.rho = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public String toString() {
        return this.getName();
    }
}

