/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.birthdeath;

import java.util.List;
import java.util.Map;
import lphy.core.distributions.Utils;
import lphy.evolution.Taxa;
import lphy.evolution.tree.TaxaConditionedTreeGenerator;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import lphy.math.MathUtils;

public class SimBDReverse
extends TaxaConditionedTreeGenerator {
    private Value<Number> birthRate;
    private Value<Number> deathRate;
    private Value<Number> rhoVal;

    public SimBDReverse(@ParameterInfo(name="lambda", description="per-lineage birth rate.") Value<Number> birthRate, @ParameterInfo(name="mu", description="per-lineage death rate.") Value<Number> deathRate, @ParameterInfo(name="taxa", description="The extant taxa that this process are conditioned on") Value<Taxa> taxa, @ParameterInfo(name="rho", description="The fraction of total extant species that the conditioned-on taxa represent. The resulting tree will have taxa.ntaxa()/rho total extant taxa.") Value<Number> rho) {
        super(null, taxa, null);
        this.birthRate = birthRate;
        this.deathRate = deathRate;
        this.rhoVal = rho;
        this.random = Utils.getRandom();
        if (!taxa.value().isUltrametric() || taxa.value().getTaxon(0).getAge() != 0.0) {
            throw new IllegalArgumentException("Taxa to condition on must all be extant!");
        }
    }

    @Override
    @GeneratorInfo(name="SimBDReverse", description="A complete birth-death tree with both extant and extinct species.<br>Conditioned on (a fraction of) extant taxa.")
    public RandomVariable<TimeTree> sample() {
        TimeTree tree = new TimeTree();
        double lambda = ValueUtils.doubleValue(this.birthRate);
        double mu = ValueUtils.doubleValue(this.deathRate);
        double rho = ValueUtils.doubleValue(this.rhoVal);
        List<TimeTreeNode> activeNodes = this.createLeafTaxa(tree);
        int maxleaf = (int)Math.round((double)activeNodes.size() / rho);
        while (activeNodes.size() < maxleaf) {
            activeNodes.add(new TimeTreeNode(0.0));
        }
        TimeTreeNode rootNode = null;
        TimeTreeNode originNode = null;
        double time = 0.0;
        while (activeNodes.size() > 0) {
            double timestep = MathUtils.nextExponential((double)activeNodes.size() * (lambda + mu), this.random);
            time += timestep;
            double specevent = this.random.nextDouble();
            if (lambda / (lambda + mu) >= specevent) {
                if (activeNodes.size() > 1) {
                    TimeTreeNode a = this.drawRandomNode(activeNodes);
                    TimeTreeNode b = this.drawRandomNode(activeNodes);
                    TimeTreeNode parent = new TimeTreeNode(time, new TimeTreeNode[]{a, b});
                    activeNodes.add(parent);
                    continue;
                }
                rootNode = activeNodes.remove(0);
                originNode = new TimeTreeNode(time, new TimeTreeNode[]{rootNode});
                if (activeNodes.size() != 0) {
                    throw new AssertionError();
                }
                continue;
            }
            activeNodes.add(new TimeTreeNode(time));
        }
        tree.setRoot(originNode, true);
        return new RandomVariable<TimeTree>(null, tree, this);
    }

    @Override
    public double logDensity(TimeTree timeTree) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public Map<String, Value> getParams() {
        Map<String, Value> params = super.getParams();
        params.put("lambda", this.birthRate);
        params.put("mu", this.deathRate);
        params.put("rho", this.rhoVal);
        return params;
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("lambda")) {
            this.birthRate = value;
        } else if (paramName.equals("mu")) {
            this.deathRate = value;
        } else if (paramName.equals("rho")) {
            this.rhoVal = value;
        } else {
            super.setParam(paramName, value);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

