/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.birthdeath;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.evolution.Taxon;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.random.RandomGenerator;

public class SimFossilsPoisson
implements GenerativeDistribution<TimeTree> {
    private Value<TimeTree> tree;
    private Value<Number> psi;
    RandomGenerator random;
    static final boolean generateSampledAncestorsAsLeafNodes = true;

    public SimFossilsPoisson(@ParameterInfo(name="tree", description="Tree to add simulated fossils to.") Value<TimeTree> tree, @ParameterInfo(name="psi", description="The fossilization rate per unit time per lineage.") Value<Number> psi) {
        this.tree = tree;
        this.psi = psi;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="SimFossilsPoisson", description="A tree with fossils added to the given tree at rate psi.")
    public RandomVariable<TimeTree> sample() {
        double samplingRate = ValueUtils.doubleValue(this.psi);
        TimeTree treeCopy = new TimeTree(this.tree.value());
        this.simulateFossils(treeCopy, samplingRate);
        return new RandomVariable<TimeTree>(null, treeCopy, this);
    }

    private void simulateFossils(TimeTree tree, double psi) {
        int nextFossilNumber = 0;
        for (TimeTreeNode node : tree.getNodes()) {
            if (node.isRoot()) continue;
            double min = node.getAge();
            double max = node.getParent().getAge();
            double expectedFossils = (max - min) * psi;
            PoissonDistribution poissonDistribution = new PoissonDistribution(this.random, expectedFossils, 1.0E-8, 100);
            int fossils = poissonDistribution.sample();
            if (fossils > 0) {
                double[] fossilTimes = new double[fossils];
                for (int i = 0; i < fossils; ++i) {
                    fossilTimes[i] = this.random.nextDouble() * (max - min) + min;
                }
                this.addFossils(fossilTimes, node.getParent(), node, nextFossilNumber, tree);
            }
            nextFossilNumber += fossils;
        }
        tree.setRoot(tree.getRoot(), true);
    }

    private void addFossils(double[] times, TimeTreeNode parent, TimeTreeNode child, int nextFossilNumber, TimeTree tree) {
        Arrays.sort(times);
        for (int i = times.length - 1; i >= 0; --i) {
            Taxon fossilTaxon = new Taxon("f_" + nextFossilNumber, times[i]);
            parent.removeChild(child);
            TimeTreeNode fossilLeafNode = new TimeTreeNode(fossilTaxon, tree);
            TimeTreeNode fossilNode = new TimeTreeNode(fossilTaxon.getAge());
            fossilNode.addChild(fossilLeafNode);
            parent.addChild(fossilNode);
            fossilNode.addChild(child);
            parent = fossilNode;
            ++nextFossilNumber;
        }
    }

    @Override
    public double logDensity(TimeTree timeTree) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("tree", SimFossilsPoisson.this.tree);
                this.put("psi", SimFossilsPoisson.this.psi);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("tree")) {
            this.tree = value;
        } else if (paramName.equals("psi")) {
            this.psi = value;
        } else {
            throw new IllegalArgumentException("Expected either tree or psi as parameter name but got " + paramName);
        }
    }

    public String toString() {
        return this.getName();
    }
}

