/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.birthdeath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lphy.core.distributions.Utils;
import lphy.evolution.tree.TaxaConditionedTreeGenerator;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.graphicalModel.Citation;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;

@Citation(value="Yule, G. U. (1925). II.\u2014 A mathematical theory of evolution, based on the conclusions of Dr. JC Willis, FRS. Philosophical transactions of the Royal Society of London. Series B, containing papers of a biological character, 213(402-410), 21-87.", year=1925, title="II. \u2014 A mathematical theory of evolution, based on the conclusions of Dr. JC Willis, FRS", authors={"Yule"}, DOI="https://doi.org/10.1098/rstb.1925.0002")
public class Yule
extends TaxaConditionedTreeGenerator {
    private Value<Number> birthRate;
    private Value<Number> rootAge;
    private List<TimeTreeNode> activeNodes;

    public Yule(@ParameterInfo(name="lambda", description="per-lineage birth rate, possibly scaled to mutations or calendar units.") Value<Number> birthRate, @ParameterInfo(name="n", description="the number of taxa.", optional=true) Value<Integer> n, @ParameterInfo(name="taxa", description="a string array of taxa id or a taxa object (e.g. dataframe, alignment or tree)", optional=true) Value taxa, @ParameterInfo(name="rootAge", description="the root age to be conditioned on. optional.", optional=true) Value<Number> rootAge) {
        super(n, taxa, null);
        this.birthRate = birthRate;
        this.rootAge = rootAge;
        this.random = Utils.getRandom();
        this.checkTaxaParameters(true);
        this.activeNodes = new ArrayList<TimeTreeNode>(2 * this.n());
    }

    @Override
    @GeneratorInfo(name="Yule", description="The Yule tree distribution over tip-labelled time trees. Will be conditional on the root age if one is provided.")
    public RandomVariable<TimeTree> sample() {
        TimeTree tree = new TimeTree(this.getTaxa());
        this.activeNodes.clear();
        this.createLeafNodes(tree, this.activeNodes);
        double time = 0.0;
        double lambda = ValueUtils.doubleValue(this.birthRate);
        double[] times = new double[this.activeNodes.size() - 1];
        if (this.rootAge == null) {
            int k = this.activeNodes.size();
            for (int i = 0; i < times.length; ++i) {
                double totalRate = lambda * (double)k;
                double x = -Math.log(this.random.nextDouble()) / totalRate;
                times[i] = time += x;
                --k;
            }
        } else {
            double t = ValueUtils.doubleValue(this.rootAge);
            for (int i = 0; i < times.length - 1; ++i) {
                times[i] = this.yuleInternalQ(this.random.nextDouble(), lambda, t);
            }
            times[times.length - 1] = t;
            Arrays.sort(times);
        }
        for (int i = 0; i < times.length; ++i) {
            TimeTreeNode a = this.drawRandomNode(this.activeNodes);
            TimeTreeNode b = this.drawRandomNode(this.activeNodes);
            TimeTreeNode parent = new TimeTreeNode(times[i], new TimeTreeNode[]{a, b});
            this.activeNodes.add(parent);
        }
        tree.setRoot(this.activeNodes.get(0));
        return new RandomVariable<TimeTree>("\u03c8", tree, this);
    }

    private double yuleInternalQ(double p, double lambda, double rootHeight) {
        double h = lambda;
        double t = rootHeight;
        double e1 = Math.exp(-h * t);
        double a2 = p * (1.0 - e1);
        return 1.0 / h * Math.log(h / (h - h * a2));
    }

    @Override
    public double logDensity(TimeTree timeTree) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public Map<String, Value> getParams() {
        Map<String, Value> map = super.getParams();
        map.put("lambda", this.birthRate);
        if (this.rootAge != null) {
            map.put("rootAge", this.rootAge);
        }
        return map;
    }

    public Value<Number> getBirthRate() {
        return this.birthRate;
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("lambda")) {
            this.birthRate = value;
        } else if (paramName.equals("rootAge")) {
            this.rootAge = value;
        } else {
            super.setParam(paramName, value);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

