/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.coalescent;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lphy.core.distributions.Utils;
import lphy.evolution.Taxa;
import lphy.evolution.tree.TaxaConditionedTreeGenerator;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.graphicalModel.Citation;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;

@Citation(value="Kingman JFC. The Coalescent. Stochastic Processes and their Applications 13, 235\u2013248 (1982)", title="The Coalescent", year=1982, authors={"Kingman"}, DOI="https://doi.org/10.1016/0304-4149(82)90011-4")
public class SerialCoalescent
extends TaxaConditionedTreeGenerator {
    private Value<Number> theta;

    public SerialCoalescent(@ParameterInfo(name="theta", narrativeName="coalescent parameter", description="effective population size, possibly scaled to mutations or calendar units.") Value<Number> theta, @ParameterInfo(name="n", description="number of taxa.", optional=true) Value<Integer> n, @ParameterInfo(name="taxa", description="Taxa object, (e.g. Taxa or TimeTree or Object[])", optional=true) Value<Taxa> taxa, @ParameterInfo(name="ages", description="an array of leaf node ages.", optional=true) Value<Double[]> ages) {
        super(n, taxa, ages);
        this.theta = theta;
        this.ages = ages;
        this.random = Utils.getRandom();
        super.checkTaxaParameters(true);
        this.checkDimensions();
    }

    private void checkDimensions() {
        boolean success = true;
        if (this.n != null && ((Integer)this.n.value()).intValue() != this.n()) {
            success = false;
        }
        if (this.ages != null && ((Double[])this.ages.value()).length != this.n()) {
            success = false;
        }
        if (!success) {
            throw new IllegalArgumentException("The number of theta values must be exactly one less than the number of taxa!");
        }
    }

    @Override
    @GeneratorInfo(name="Coalescent", narrativeName="Kingman's coalescent tree prior", description="The Kingman coalescent with serially sampled data. (Rodrigo and Felsenstein, 1999)")
    public RandomVariable<TimeTree> sample() {
        TimeTree tree = new TimeTree();
        List<TimeTreeNode> leafNodes = this.createLeafTaxa(tree);
        ArrayList<TimeTreeNode> activeNodes = new ArrayList<TimeTreeNode>();
        ArrayList<TimeTreeNode> leavesToBeAdded = new ArrayList<TimeTreeNode>();
        double time = 0.0;
        for (TimeTreeNode leaf : leafNodes) {
            if (leaf.getAge() <= time) {
                activeNodes.add(leaf);
                continue;
            }
            leavesToBeAdded.add(leaf);
        }
        leavesToBeAdded.sort((o1, o2) -> Double.compare(o2.getAge(), o1.getAge()));
        double popSize = ValueUtils.doubleValue(this.theta);
        while (activeNodes.size() + leavesToBeAdded.size() > 1) {
            int k = activeNodes.size();
            if (k == 1) {
                time = ((TimeTreeNode)leavesToBeAdded.get(leavesToBeAdded.size() - 1)).getAge();
            } else {
                double rate = (double)k * ((double)k - 1.0) / (popSize * 2.0);
                double x = -Math.log(this.random.nextDouble()) / rate;
                time += x;
                if (leavesToBeAdded.size() > 0 && time > ((TimeTreeNode)leavesToBeAdded.get(leavesToBeAdded.size() - 1)).getAge()) {
                    time = ((TimeTreeNode)leavesToBeAdded.get(leavesToBeAdded.size() - 1)).getAge();
                } else {
                    TimeTreeNode a = (TimeTreeNode)activeNodes.remove(this.random.nextInt(activeNodes.size()));
                    TimeTreeNode b = (TimeTreeNode)activeNodes.remove(this.random.nextInt(activeNodes.size()));
                    TimeTreeNode parent = new TimeTreeNode(time, new TimeTreeNode[]{a, b});
                    activeNodes.add(parent);
                }
            }
            while (leavesToBeAdded.size() > 0 && ((TimeTreeNode)leavesToBeAdded.get(leavesToBeAdded.size() - 1)).getAge() == time) {
                TimeTreeNode youngest = (TimeTreeNode)leavesToBeAdded.remove(leavesToBeAdded.size() - 1);
                activeNodes.add(youngest);
            }
        }
        tree.setRoot((TimeTreeNode)activeNodes.get(0));
        return new RandomVariable<TimeTree>("\u03c8", tree, this);
    }

    @Override
    public double logDensity(TimeTree timeTree) {
        return 0.0;
    }

    @Override
    public Map<String, Value> getParams() {
        Map<String, Value> map = super.getParams();
        map.put("theta", this.theta);
        return map;
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("theta")) {
            this.theta = value;
        } else {
            super.setParam(paramName, value);
        }
    }

    public Value<Number> getTheta() {
        return this.theta;
    }
}

