/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.continuous;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.evolution.Taxa;
import lphy.evolution.alignment.ContinuousCharacterData;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.graphicalModel.Citation;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleValue;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.random.RandomGenerator;

@Citation(value="Felsenstein J. (1973). Maximum-likelihood estimation of evolutionary trees from continuous characters. American journal of human genetics, 25(5), 471\u2013492.", title="Maximum-likelihood estimation of evolutionary trees from continuous characters", authors={"Felsenstein"}, year=1973, DOI="https://www.ncbi.nlm.nih.gov/pmc/articles/PMC1762641/")
public class PhyloBrownian
implements GenerativeDistribution<ContinuousCharacterData> {
    Value<TimeTree> tree;
    protected Value<Double> diffusionRate;
    Value<Double> y0;
    RandomGenerator random;
    public static final String treeParamName = "tree";
    public static final String diffRateParamName = "diffRate";
    public static final String y0ParamName = "y0";

    public PhyloBrownian(@ParameterInfo(name="tree", description="the time tree.") Value<TimeTree> tree, @ParameterInfo(name="diffRate", narrativeName="evolutionary rate", description="the diffusion rate.") Value<Double> diffusionRate, @ParameterInfo(name="y0", narrativeName="root value", description="the value of continuous trait at the root.") Value<Double> y0) {
        this.tree = tree;
        this.diffusionRate = diffusionRate;
        this.y0 = y0;
        this.random = Utils.getRandom();
    }

    PhyloBrownian() {
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put(PhyloBrownian.treeParamName, PhyloBrownian.this.tree);
                this.put(PhyloBrownian.diffRateParamName, PhyloBrownian.this.diffusionRate);
                this.put(PhyloBrownian.y0ParamName, PhyloBrownian.this.y0);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "tree": {
                this.tree = value;
                break;
            }
            case "diffRate": {
                this.diffusionRate = value;
                break;
            }
            case "y0": {
                this.y0 = value;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised parameter name: " + paramName);
            }
        }
    }

    @Override
    @GeneratorInfo(name="PhyloBrownian", verbClause="is assumed to have evolved under", narrativeName="phylogenetic Brownian motion process", description="The phylogenetic Brownian motion distribution. A continous trait is simulated for every leaf node, and every direct ancestor node with an id.(The sampling distribution that the phylogenetic continuous trait likelihood is derived from.)")
    public RandomVariable<ContinuousCharacterData> sample() {
        TreeMap<String, Integer> idMap = new TreeMap<String, Integer>();
        this.fillIdMap(this.tree.value().getRoot(), idMap);
        TreeMap<String, Double> tipValues = new TreeMap<String, Double>();
        this.traverseTree(this.tree.value().getRoot(), this.y0, tipValues, this.diffusionRate.value(), idMap);
        Taxa taxa = Taxa.createTaxa(tipValues.keySet().toArray());
        Double[][] values = new Double[taxa.ntaxa()][1];
        String[] names = taxa.getTaxaNames();
        for (int i = 0; i < names.length; ++i) {
            values[i][0] = (Double)tipValues.get(names[i]);
        }
        ContinuousCharacterData continuousCharacterData = new ContinuousCharacterData(taxa, values);
        return new RandomVariable<ContinuousCharacterData>(null, continuousCharacterData, this);
    }

    @Override
    public String getTypeName() {
        return "Continuous Character Data";
    }

    private void fillIdMap(TimeTreeNode node, SortedMap<String, Integer> idMap) {
        if (node.isLeaf()) {
            Integer i = (Integer)idMap.get(node.getId());
            if (i == null) {
                int nextValue = 0;
                for (Integer j : idMap.values()) {
                    if (j < nextValue) continue;
                    nextValue = j + 1;
                }
                idMap.put(node.getId(), nextValue);
            }
        } else {
            for (TimeTreeNode child : node.getChildren()) {
                this.fillIdMap(child, idMap);
            }
        }
    }

    private void traverseTree(TimeTreeNode node, Value<Double> nodeState, Map<String, Double> tipValues, double diffusionRate, Map<String, Integer> idMap) {
        if (node.isLeaf()) {
            tipValues.put(node.getId(), nodeState.value());
        } else {
            for (TimeTreeNode child : node.getChildren()) {
                double variance = diffusionRate * (node.getAge() - child.getAge());
                double newState = this.sampleNewState(nodeState.value(), variance, child.getIndex());
                this.traverseTree(child, new DoubleValue("x", newState), tipValues, diffusionRate, idMap);
            }
        }
    }

    protected double sampleNewState(double initialState, double time, int nodeIndex) {
        NormalDistribution distribution = new NormalDistribution(initialState, Math.sqrt(time * this.diffusionRate.value()));
        return this.handleBoundaries(distribution.sample());
    }

    protected double handleBoundaries(double rawValue) {
        return rawValue;
    }
}

