/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.continuous;

import java.util.SortedMap;
import java.util.TreeMap;
import lphy.evolution.alignment.ContinuousCharacterData;
import lphy.evolution.continuous.PhyloBrownian;
import lphy.evolution.tree.TimeTree;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.distribution.NormalDistribution;

public class PhyloOU
extends PhyloBrownian {
    protected Value<Double> theta;
    protected Value<Double> alpha;
    protected Value<Double[]> branchThetas;
    public static final String thetaParamName = "theta";
    public static final String branchThetasParamName = "branchThetas";
    public static final String alphaParamName = "alpha";

    public PhyloOU(@ParameterInfo(name="tree", description="the time tree.") Value<TimeTree> tree, @ParameterInfo(name="diffRate", description="the variance of the underlying Brownian process. This is not the equilibrium variance of the OU process.") Value<Double> variance, @ParameterInfo(name="theta", description="the 'optimal' value that the long-term process is centered around.", optional=true) Value<Double> theta, @ParameterInfo(name="alpha", description="the drift term that determines the rate of drift towards the optimal value.") Value<Double> alpha, @ParameterInfo(name="y0", description="the value of continuous trait at the root.") Value<Double> y0, @ParameterInfo(name="branchThetas", description="the 'optimal' value for each branch in the tree.", optional=true) Value<Double[]> branchThetas) {
        super(tree, variance, y0);
        this.theta = theta;
        this.branchThetas = branchThetas;
        this.alpha = alpha;
    }

    public SortedMap<String, Value> getParams() {
        TreeMap<String, Value> map = new TreeMap<String, Value>();
        map.put("tree", this.tree);
        map.put("diffRate", this.diffusionRate);
        if (this.theta != null) {
            map.put(thetaParamName, this.theta);
        }
        map.put(alphaParamName, this.alpha);
        map.put("y0", this.y0);
        if (this.branchThetas != null) {
            map.put(branchThetasParamName, this.branchThetas);
        }
        return map;
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("tree")) {
            this.tree = value;
        } else if (paramName.equals("diffRate")) {
            this.diffusionRate = value;
        } else if (paramName.equals(thetaParamName)) {
            this.theta = value;
        } else if (paramName.equals(branchThetasParamName)) {
            this.branchThetas = value;
        } else if (paramName.equals(alphaParamName)) {
            this.alpha = value;
        } else if (paramName.equals("y0")) {
            this.y0 = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    @Override
    protected double sampleNewState(double initialState, double time, int nodeIndex) {
        double th = this.theta != null ? this.theta.value().doubleValue() : this.branchThetas.value()[nodeIndex].doubleValue();
        double a = this.alpha.value();
        double v = (Double)this.diffusionRate.value() / (2.0 * a);
        double weight = Math.exp(-a * time);
        double mean = (1.0 - weight) * th + weight * initialState;
        double variance = v * (1.0 - Math.exp(-2.0 * a * time));
        NormalDistribution distribution = new NormalDistribution(mean, Math.sqrt(variance));
        return this.handleBoundaries(distribution.sample());
    }

    @Override
    @GeneratorInfo(name="PhyloOU", verbClause="is assumed to have evolved under", narrativeName="phylogenetic Ornstein-Ulhenbeck process", description="The phylogenetic Ornstein-Ulhenbeck distribution. A continous trait is simulated for every leaf node, and every direct ancestor node with an id.")
    public RandomVariable<ContinuousCharacterData> sample() {
        return super.sample();
    }
}

