/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.datatype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jebl.evolution.sequences.State;
import lphy.evolution.datatype.BinaryState;
import lphy.evolution.datatype.DataType;

public final class Binary
extends DataType {
    private static Binary instance;
    public static final String NAME = "binary";
    public static final BinaryState ZERO_STATE;
    public static final BinaryState ONE_STATE;
    public static final BinaryState[] CANONICAL_STATES;
    public static final BinaryState UNKNOWN_STATE;
    public static final BinaryState GAP_STATE;
    public static final BinaryState[] STATES;

    private Binary() {
    }

    public static Binary getInstance() {
        if (instance == null) {
            instance = new Binary();
        }
        return instance;
    }

    public int getStateCount() {
        return STATES.length;
    }

    @Override
    public List<State> getStates() {
        return Collections.unmodifiableList(Arrays.asList((State[])STATES));
    }

    public int getCanonicalStateCount() {
        return CANONICAL_STATES.length;
    }

    public List<? extends State> getCanonicalStates() {
        return Collections.unmodifiableList(Arrays.asList((State[])CANONICAL_STATES));
    }

    public int getCodeLength() {
        return 1;
    }

    public State getState(int index) {
        return STATES[index];
    }

    public State getUnknownState() {
        return UNKNOWN_STATE;
    }

    public State getGapState() {
        return GAP_STATE;
    }

    public boolean isUnknown(State state) {
        return state == UNKNOWN_STATE;
    }

    public boolean isGap(State state) {
        return state == GAP_STATE;
    }

    public String getName() {
        return NAME;
    }

    public String getNexusDataType() {
        return NAME;
    }

    static {
        ZERO_STATE = new BinaryState("0", "0", 0);
        ONE_STATE = new BinaryState("1", "1", 1);
        CANONICAL_STATES = new BinaryState[]{ZERO_STATE, ONE_STATE};
        UNKNOWN_STATE = new BinaryState("Unknown base", "?", 2, CANONICAL_STATES);
        GAP_STATE = new BinaryState("Gap", "-", 3, CANONICAL_STATES);
        STATES = new BinaryState[]{ZERO_STATE, ONE_STATE, UNKNOWN_STATE, GAP_STATE};
    }
}

