/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.datatype;

import java.util.Arrays;
import java.util.List;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;

public abstract class DataType
implements SequenceType {
    protected static final char[] NUCL_CHAR = new char[]{'A', 'C', 'G', 'T'};
    protected static final int STATES_BY_CODE_SIZE = 128;

    public static boolean isSame(SequenceType type1, SequenceType type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.getName().equalsIgnoreCase(type2.getName());
    }

    public abstract List<State> getStates();

    public State getState(char code) {
        if (code < '\u0000' || code >= '\u0080') {
            return null;
        }
        State[] statesByCode = this.getStatesByCode();
        return statesByCode[code];
    }

    public State getState(String code) {
        return this.getState(code.charAt(0));
    }

    protected State[] getStatesByCode() {
        Object[] statesByCode = new State[128];
        Arrays.fill(statesByCode, null);
        for (State state : this.getStates()) {
            char code = state.getCode().charAt(0);
            statesByCode[code] = state;
            statesByCode[Character.toLowerCase((char)code)] = state;
        }
        return statesByCode;
    }

    public State[] toStateArray(String sequenceString) {
        State[] seq = new State[sequenceString.length()];
        for (int i = 0; i < seq.length; ++i) {
            seq[i] = this.getState(sequenceString.charAt(i));
        }
        return seq;
    }

    public State[] toStateArray(byte[] indexArray) {
        State[] seq = new State[indexArray.length];
        for (int i = 0; i < seq.length; ++i) {
            seq[i] = this.getState(indexArray[i]);
        }
        return seq;
    }
}

