/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.datatype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jebl.evolution.sequences.State;
import lphy.evolution.datatype.DataType;
import lphy.evolution.datatype.StandardState;

public class Standard
extends DataType {
    private final StandardState[] CANONICAL_STATES;
    private final StandardState[] STATES;
    private final StandardState UNKNOWN_STATE;
    private final Map<String, StandardState> statesByCode;
    public static final String NAME = "standard";

    public Standard(int numCanoStates) {
        int i;
        assert (numCanoStates > 1);
        ArrayList<StandardState> states = new ArrayList<StandardState>(numCanoStates);
        for (int i2 = 0; i2 < numCanoStates; ++i2) {
            String name = String.valueOf(i2);
            StandardState state = new StandardState(name, i2);
            states.add(state);
        }
        this.CANONICAL_STATES = (StandardState[])states.toArray(StandardState[]::new);
        int len = this.CANONICAL_STATES.length;
        this.UNKNOWN_STATE = new StandardState("?", len, this.CANONICAL_STATES);
        this.STATES = new StandardState[len + 1];
        for (i = 0; i < len; ++i) {
            this.STATES[i] = this.CANONICAL_STATES[i];
        }
        this.STATES[len] = this.UNKNOWN_STATE;
        this.statesByCode = new HashMap<String, StandardState>();
        for (i = 0; i < this.STATES.length; ++i) {
            this.statesByCode.put(this.STATES[i].getCode(), this.STATES[i]);
        }
    }

    public Standard(List<String> stateNames) {
        int i;
        assert (stateNames.size() > 1);
        ArrayList<StandardState> states = new ArrayList<StandardState>(stateNames.size());
        for (int i2 = 0; i2 < stateNames.size(); ++i2) {
            String name = stateNames.get(i2);
            StandardState state = new StandardState(name, i2);
            states.add(state);
        }
        this.CANONICAL_STATES = (StandardState[])states.toArray(StandardState[]::new);
        int len = this.CANONICAL_STATES.length;
        this.UNKNOWN_STATE = new StandardState("?", len, this.CANONICAL_STATES);
        this.STATES = new StandardState[len + 1];
        for (i = 0; i < len; ++i) {
            this.STATES[i] = this.CANONICAL_STATES[i];
        }
        this.STATES[len] = this.UNKNOWN_STATE;
        this.statesByCode = new HashMap<String, StandardState>();
        for (i = 0; i < this.STATES.length; ++i) {
            this.statesByCode.put(this.STATES[i].getCode(), this.STATES[i]);
        }
    }

    public StandardState getStateFromName(String name) {
        for (StandardState state : this.STATES) {
            if (!state.getFullName().equals(name)) continue;
            return state;
        }
        return null;
    }

    public int getStateCount() {
        return this.STATES.length;
    }

    @Override
    public List<State> getStates() {
        return Collections.unmodifiableList(Arrays.asList((State[])this.STATES));
    }

    public int getCanonicalStateCount() {
        return this.CANONICAL_STATES.length;
    }

    public List<? extends State> getCanonicalStates() {
        return Collections.unmodifiableList(Arrays.asList((State[])this.CANONICAL_STATES));
    }

    public int getCodeLength() {
        throw new UnsupportedOperationException("Standard data type only allow 1 site in the sequence, normally used by traits !");
    }

    public State getState(int index) {
        return this.STATES[index];
    }

    public State getUnknownState() {
        return this.UNKNOWN_STATE;
    }

    public State getGapState() {
        throw new UnsupportedOperationException("");
    }

    public boolean isUnknown(State state) {
        return state == this.UNKNOWN_STATE;
    }

    public boolean isGap(State state) {
        throw new UnsupportedOperationException("");
    }

    public String getName() {
        return NAME;
    }

    public String getNexusDataType() {
        return NAME;
    }
}

