/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.functions;

import java.util.ArrayList;
import lphy.evolution.Taxa;
import lphy.evolution.Taxon;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class ExtantTaxa
extends DeterministicFunction<Taxa> {
    private static final String taxaParamName = "taxa";

    public ExtantTaxa(@ParameterInfo(name="taxa", description="the taxa-dimensioned value.") Value<Taxa> x) {
        this.setParam(taxaParamName, (Value)x);
    }

    @Override
    @GeneratorInfo(name="extantTaxa", description="Returns the extant taxa from the given taxa object.")
    public Value<Taxa> apply() {
        Value v = this.getParams().get(taxaParamName);
        ArrayList<Taxon> taxonList = new ArrayList<Taxon>();
        for (Taxon taxon : ((Taxa)v.value()).getTaxonArray()) {
            if (!taxon.isExtant()) continue;
            taxonList.add(taxon);
        }
        Taxa.Simple extantTaxa = new Taxa.Simple(taxonList.toArray(new Taxon[0]));
        return new Value<Taxa>(null, extantTaxa, this);
    }
}

