/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.io;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jebl.evolution.sequences.SequenceType;
import lphy.evolution.Taxa;
import lphy.evolution.Taxon;
import lphy.evolution.alignment.Alignment;
import lphy.evolution.alignment.AlignmentUtils;
import lphy.evolution.alignment.SimpleAlignment;
import lphy.evolution.traits.CharSetBlock;
import lphy.graphicalModel.MethodInfo;
import lphy.util.LoggerUtils;

public class MetaDataAlignment
extends SimpleAlignment {
    protected Map<String, List<CharSetBlock>> charsetMap;
    protected double minAge;
    protected double maxAge;
    protected ChronoUnit chronoUnit = ChronoUnit.YEARS;
    protected AgeDirection ageDirection = AgeDirection.forward;
    protected String ageRegxStr;
    protected String spRegxStr;

    public MetaDataAlignment(Taxa taxa, int nchar, SequenceType sequenceType) {
        super(taxa, nchar, sequenceType);
    }

    public void assignAges(Map<String, String> ageStringMap, String ageDirectionStr) {
        this.ageDirection = this.getAgeDirection(ageDirectionStr);
        String[] datesStr = (String[])Objects.requireNonNull(ageStringMap).values().toArray(String[]::new);
        double[] vals = this.parseDateString(datesStr);
        if (vals == null) {
            assert (AgeDirection.forward.equals((Object)this.ageDirection) || AgeDirection.dates.equals((Object)this.ageDirection));
            vals = this.convertDateToAge(datesStr, ChronoUnit.YEARS);
        }
        this.maxAge = vals[0];
        this.minAge = vals[0];
        for (int i = 1; i < vals.length; ++i) {
            if (vals[i] > this.maxAge) {
                this.maxAge = vals[i];
                continue;
            }
            if (!(vals[i] < this.minAge)) continue;
            this.minAge = vals[i];
        }
        String[] taxaNames = (String[])ageStringMap.keySet().toArray(String[]::new);
        if (ageStringMap.size() != this.ntaxa()) {
            throw new IllegalArgumentException("Invalid ages/dates map : size " + ageStringMap.size() + " !=  taxa " + this.ntaxa());
        }
        for (int i = 0; i < taxaNames.length; ++i) {
            String taxonName = taxaNames[i];
            int indexOfTaxon = this.indexOfTaxon(taxonName);
            if (indexOfTaxon < 0) {
                throw new RuntimeException("Cannot locate taxon name " + taxonName + " from ages/dates map in getAlignment() taxa " + Arrays.toString(this.getTaxaNames()));
            }
            if (AgeDirection.forward.equals((Object)this.ageDirection) || AgeDirection.dates.equals((Object)this.ageDirection)) {
                this.getTaxon(indexOfTaxon).setAge(this.maxAge - vals[i]);
                continue;
            }
            if (AgeDirection.backward.equals((Object)this.ageDirection) || AgeDirection.ages.equals((Object)this.ageDirection)) {
                this.getTaxon(indexOfTaxon).setAge(vals[i] - this.minAge);
                continue;
            }
            throw new IllegalArgumentException("Not recognised age direction to convert dates or ages : " + this.ageDirection);
        }
    }

    public void setAgesFromTaxaName(String ageRegxStr, String ageDirectionStr) {
        this.ageRegxStr = ageRegxStr;
        TreeMap<String, String> ageStringMap = new TreeMap<String, String>();
        Pattern regx = Pattern.compile(ageRegxStr);
        for (String taxonName : this.getTaxaNames()) {
            String ageStr = this.getAttrFirstMatch(taxonName, regx);
            ageStringMap.put(taxonName, ageStr);
        }
        this.assignAges(ageStringMap, ageDirectionStr);
    }

    public void setSpeciesFromTaxaName(String spRegxStr) {
        this.spRegxStr = spRegxStr;
        Pattern regx = Pattern.compile(spRegxStr);
        for (Taxon taxon : this.getTaxonArray()) {
            String taxonName = taxon.getName();
            String spStr = this.getAttrFirstMatch(taxonName, regx);
            taxon.setSpecies(Objects.requireNonNull(spStr));
        }
    }

    public ChronoUnit getChronoUnit() {
        return this.chronoUnit;
    }

    public void setChronoUnit(ChronoUnit chronoUnit) {
        this.chronoUnit = chronoUnit;
    }

    @MethodInfo(description="return a partition alignment. If the string doesn't match charset's syntax, then check if the string matches a defined name in the nexus file. Otherwise it is an error. The string is referred to one partition at a call, but can be multiple blocks, such as d.charset(\"2-457\\3 660-896\\3\").", narrativeName="character set")
    public Alignment charset(String str) {
        List<Object> charSetBlocks = new ArrayList();
        if (CharSetBlock.Utils.isValid(str)) {
            charSetBlocks = CharSetBlock.Utils.getCharSetBlocks(str);
        } else if (this.hasCharsets(this.charsetMap)) {
            charSetBlocks = this.getCharSet(str, this.charsetMap);
        }
        if (charSetBlocks.size() < 1) {
            throw new IllegalArgumentException("Not recognised string " + str + " assign to charset !");
        }
        return AlignmentUtils.getCharSetAlignment(charSetBlocks, this);
    }

    public void setCharsetMap(Map<String, List<CharSetBlock>> charsetMap) {
        this.charsetMap = charsetMap;
    }

    public Map<String, List<CharSetBlock>> getCharsetMap() {
        return this.charsetMap;
    }

    public AgeDirection getAgeDirection() {
        return this.ageDirection;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.getCharsetMap() != null) {
            sb.append(", ").append(this.getCharsetMap().size()).append(" charset(s)");
        }
        if (this.isUltrametric()) {
            sb.append(", age direction is ").append((Object)this.getAgeDirection());
        }
        return sb.toString();
    }

    private AgeDirection getAgeDirection(String ageDirectionStr) {
        if (ageDirectionStr == null) {
            ageDirectionStr = AgeDirection.forward.toString();
            LoggerUtils.log.warning("Tip calibration type is not defined, set to " + ageDirectionStr + " as default.");
        }
        return AgeDirection.valueOf(ageDirectionStr.toLowerCase());
    }

    private String getAttrFirstMatch(String taxonName, Pattern regx) {
        Matcher matcher = regx.matcher(taxonName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Cannot extract attributes from " + taxonName + " using " + regx);
    }

    private double[] parseDateString(String[] datesStr) {
        double[] vals = new double[Objects.requireNonNull(datesStr).length];
        for (int i = 0; i < datesStr.length; ++i) {
            try {
                vals[i] = Double.parseDouble(datesStr[i]);
                continue;
            }
            catch (NumberFormatException e) {
                LoggerUtils.log.warning("Warning: the value (" + datesStr[i] + ") is not numeric, so guess it is a date by uuuu-MM-dd format");
                return null;
            }
        }
        return vals;
    }

    private double[] convertDateToAge(String[] datesStr, ChronoUnit unit) {
        String formatter = "uuuu-MM-dd";
        DateTimeFormatter f = DateTimeFormatter.ofPattern("uuuu-MM-dd");
        if (!unit.equals(ChronoUnit.YEARS)) {
            throw new UnsupportedOperationException("Only support year as unit for parsing a date 'uuuu-MM-dd' !");
        }
        double[] vals = new double[Objects.requireNonNull(datesStr).length];
        for (int i = 0; i < datesStr.length; ++i) {
            try {
                LocalDate date = LocalDate.parse(datesStr[i], f);
                vals[i] = (double)date.getYear() + ((double)date.getDayOfYear() - 1.0) / (date.isLeapYear() ? 366.0 : 365.0);
                continue;
            }
            catch (DateTimeParseException e) {
                throw new RuntimeException("Cannot parse the date string by uuuu-MM-dd ! " + datesStr[i]);
            }
        }
        return vals;
    }

    private boolean hasCharsets(Map<String, List<CharSetBlock>> charsetMap) {
        return charsetMap != null && charsetMap.size() != 0;
    }

    private List<CharSetBlock> getCharSet(String partName, Map<String, List<CharSetBlock>> charsetMap) {
        List<CharSetBlock> blocks = Objects.requireNonNull(charsetMap).get(partName);
        if (blocks == null) {
            throw new IllegalArgumentException("Charset name " + partName + " not exist !");
        }
        return blocks;
    }

    public static enum AgeDirection {
        forward,
        backward,
        dates,
        ages;

    }
}

