/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.sitemodel;

import lphy.graphicalModel.MethodInfo;
import lphy.graphicalModel.MultiDimensional;

public class SiteModel
implements MultiDimensional {
    Double[][] Q;
    Double[] siteRates;
    Double proportionInvariable;
    int nchar;

    public SiteModel(Double[][] Q, Double[] siteRates, Double proportionInvariable) {
        this.Q = Q;
        this.siteRates = siteRates;
        this.proportionInvariable = proportionInvariable;
    }

    @MethodInfo(description="the Q matrix for this site model")
    public Double[][] getQ() {
        return this.Q;
    }

    public boolean hasSiteRates() {
        return this.siteRates != null;
    }

    @MethodInfo(description="the raw site rates for this site model")
    public Double[] siteRates() {
        return this.siteRates;
    }

    public Integer stateCount() {
        return this.Q.length;
    }

    @MethodInfo(description="the proportion of invariable sites")
    public Double getProportionInvariable() {
        return this.proportionInvariable;
    }

    @Override
    public int getDimension() {
        return 1 + this.Q.length * this.Q.length + this.siteRates.length;
    }
}

