/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.substitutionmodel;

import lphy.evolution.substitutionmodel.RateMatrix;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleArray2DValue;

public class F81
extends RateMatrix {
    public static final String freqParamName = "freq";

    public F81(@ParameterInfo(name="freq", description="the base frequencies.") Value<Double[]> freq, @ParameterInfo(name="meanRate", description="the mean rate of the process. default = 1.0", optional=true) Value<Number> meanRate) {
        super(meanRate);
        this.setParam(freqParamName, (Value)freq);
    }

    @Override
    @GeneratorInfo(name="f81", description="The F81 instantaneous rate matrix. Takes base frequencies and produces an F81 rate matrix.")
    public Value<Double[][]> apply() {
        Value<Double[]> freq = this.getFreq();
        return new DoubleArray2DValue(this.f81(freq.value()), (DeterministicFunction)this);
    }

    private Double[][] f81(Double[] freqs) {
        int numStates = 4;
        Double[][] Q = new Double[numStates][numStates];
        double[] totalRates = new double[numStates];
        for (int i = 0; i < numStates; ++i) {
            for (int j = 0; j < numStates; ++j) {
                if (i != j) {
                    Q[i][j] = freqs[j];
                } else {
                    Q[i][i] = 0.0;
                }
                int n = i;
                totalRates[n] = totalRates[n] + Q[i][j];
            }
            Q[i][i] = -totalRates[i];
        }
        this.normalize(freqs, Q);
        return Q;
    }

    public Value<Double[]> getFreq() {
        return this.getParams().get(freqParamName);
    }
}

