/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.substitutionmodel;

import lphy.evolution.substitutionmodel.RateMatrix;
import lphy.graphicalModel.Citation;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleArray2DValue;

@Citation(value="Rodriguez, F. J. L. O. J., Oliver, J. L., Mar\u00edn, A., & Medina, J. R. (1990). The general stochastic model of nucleotide substitution. Journal of theoretical biology, 142(4), 485-501.", title="The general stochastic model of nucleotide substitution", authors={"Rodriguez", "Oliver", "Mar\u00edn", "Medina"}, year=1990, DOI="https://doi.org/10.1016/S0022-5193(05)80104-3")
public class GTR
extends RateMatrix {
    public static final String ratesParamName = "rates";
    public static final String freqParamName = "freq";

    public GTR(@ParameterInfo(name="rates", narrativeName="relative rates", description="the relative rates of the GTR process.") Value<Double[]> rates, @ParameterInfo(name="freq", narrativeName="base frequencies", description="the base frequencies.") Value<Double[]> freq, @ParameterInfo(name="meanRate", narrativeName="substitution rate", description="the rate of substitution.", optional=true) Value<Number> meanRate) {
        super(meanRate);
        if (rates.value().length != 6) {
            throw new IllegalArgumentException("Rates must have 6 dimensions.");
        }
        this.setParam(ratesParamName, (Value)rates);
        this.setParam(freqParamName, (Value)freq);
    }

    @Override
    @GeneratorInfo(name="gtr", verbClause="is", narrativeName="general time-reversible rate matrix", description="The GTR instantaneous rate matrix. Takes relative rates and base frequencies and produces an GTR rate matrix.")
    public Value<Double[][]> apply() {
        Value<Double[]> rates = this.getRates();
        Value freq = this.getParams().get(freqParamName);
        return new DoubleArray2DValue(this.gtr(rates.value(), (Double[])freq.value()), (DeterministicFunction)this);
    }

    private Double[][] gtr(Double[] rates, Double[] freqs) {
        int i;
        int numStates = 4;
        Double[][] Q = new Double[numStates][numStates];
        double[] totalRates = new double[numStates];
        int upper = 0;
        for (i = 0; i < numStates; ++i) {
            for (int j = i + 1; j < numStates; ++j) {
                Q[i][j] = rates[upper] * freqs[j];
                Q[j][i] = rates[upper] * freqs[i];
                ++upper;
            }
        }
        for (i = 0; i < numStates; ++i) {
            double totalRate = 0.0;
            for (int j = 0; j < numStates; ++j) {
                if (j == i) continue;
                totalRate += Q[i][j].doubleValue();
            }
            Q[i][i] = -totalRate;
        }
        this.normalize(freqs, Q, this.totalRateDefault1());
        return Q;
    }

    public Value<Double[]> getRates() {
        return this.getParams().get(ratesParamName);
    }

    public Value<Double[]> getFreq() {
        return this.getParams().get(freqParamName);
    }
}

