/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.substitutionmodel;

import java.util.Map;
import lphy.evolution.substitutionmodel.RateMatrix;
import lphy.graphicalModel.Citation;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import lphy.graphicalModel.types.DoubleArray2DValue;

@Citation(value="Hasegawa, M., Kishino, H. & Yano, T. Dating of the human-ape splitting by a molecular clock of mitochondrial DNA. J Mol Evol 22, 160\u2013174 (1985)", title="Dating of the human-ape splitting by a molecular clock of mitochondrial DNA", year=1985, authors={"Hasegawa", "Kishino", "Yano"}, DOI="https://doi.org/10.1007/BF02101694")
public class HKY
extends RateMatrix {
    public static final String kappaParamName = "kappa";
    public static final String freqParamName = "freq";

    public HKY(@ParameterInfo(name="kappa", narrativeName="transition bias parameter", description="the kappa of the HKY process.") Value<Number> kappa, @ParameterInfo(name="freq", narrativeName="base frequency vector", description="the base frequencies.") Value<Double[]> freq, @ParameterInfo(name="meanRate", narrativeName="rate", description="the total rate of substitution per unit time. Default 1.0.", optional=true) Value<Number> rate) {
        super(rate);
        this.setParam(kappaParamName, (Value)kappa);
        this.setParam(freqParamName, (Value)freq);
    }

    @Override
    @GeneratorInfo(name="hky", verbClause="is", narrativeName="HKY model", description="The HKY instantaneous rate matrix. Takes a kappa and base frequencies (and optionally a total rate) and produces an HKY85 rate matrix.")
    public Value<Double[][]> apply() {
        Map<String, Value> params = this.getParams();
        double kappa = ValueUtils.doubleValue(params.get(kappaParamName));
        Double[] freq = (Double[])params.get(freqParamName).value();
        return new DoubleArray2DValue(this.hky(kappa, freq), (DeterministicFunction)this);
    }

    public Value<Double> getKappa() {
        return this.getParams().get(kappaParamName);
    }

    public Value<Double[]> getFreq() {
        return this.getParams().get(freqParamName);
    }

    private Double[][] hky(double kappa, Double[] freqs) {
        int numStates = 4;
        Double[][] Q = new Double[numStates][numStates];
        double[] totalRates = new double[numStates];
        for (int i = 0; i < numStates; ++i) {
            for (int j = 0; j < numStates; ++j) {
                if (i != j) {
                    Q[i][j] = Math.abs(i - j) == 2 ? Double.valueOf(kappa * freqs[j]) : freqs[j];
                } else {
                    Q[i][i] = 0.0;
                }
                int n = i;
                totalRates[n] = totalRates[n] + Q[i][j];
            }
            Q[i][i] = -totalRates[i];
        }
        this.normalize(freqs, Q);
        return Q;
    }

    public static void main(String ... args) throws ClassNotFoundException {
        System.out.println(Double[].class.getName());
        System.out.println(Class.forName("[Ljava.lang.Double;"));
    }
}

