/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.substitutionmodel;

import lphy.evolution.substitutionmodel.RateMatrix;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleArray2DValue;

public class K80
extends RateMatrix {
    public static final String kappaParamName = "kappa";

    public K80(@ParameterInfo(name="kappa", description="the kappa of the K80 process.") Value<Double> kappa, @ParameterInfo(name="meanRate", description="the mean rate of the K80 process. default 1.0", optional=true) Value<Number> meanRate) {
        super(meanRate);
        this.setParam(kappaParamName, (Value)kappa);
    }

    @Override
    @GeneratorInfo(name="k80", description="The K80 instantaneous rate matrix. Takes a kappa and produces a K80 rate matrix.")
    public Value<Double[][]> apply() {
        Value<Double> kappa = this.getKappa();
        return new DoubleArray2DValue(this.k80(kappa.value()), (DeterministicFunction)this);
    }

    private Double[][] k80(double kappa) {
        int numStates = 4;
        Double[][] Q = new Double[numStates][numStates];
        double[] totalRates = new double[numStates];
        for (int i = 0; i < numStates; ++i) {
            for (int j = 0; j < numStates; ++j) {
                if (i != j) {
                    Q[i][j] = Math.abs(i - j) == 2 ? Double.valueOf(kappa) : Double.valueOf(1.0);
                }
                int n = i;
                totalRates[n] = totalRates[n] + Q[i][j];
            }
            Q[i][i] = -totalRates[i];
        }
        this.normalize(new Double[]{0.25, 0.25, 0.25, 0.25}, Q, this.totalRateDefault1());
        return Q;
    }

    public Value<Double> getKappa() {
        return this.getParams().get(kappaParamName);
    }
}

