/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.substitutionmodel;

import lphy.evolution.substitutionmodel.RateMatrix;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import lphy.graphicalModel.types.DoubleArray2DValue;

public class LewisMK
extends RateMatrix {
    public static final String numStatesParamName = "numStates";

    public LewisMK(@ParameterInfo(name="numStates", description="the number of states") Value<Integer> numStates, @ParameterInfo(name="meanRate", description="the mean rate of the LewisMK process. Default value is 1.0.", optional=true) Value<Number> rate) {
        super(rate);
        this.setParam(numStatesParamName, (Value)numStates);
    }

    @Override
    @GeneratorInfo(name="lewisMK", description="The LewisMK Q matrix construction function. Takes a mean rate and a number of states and produces a LewisMK Q matrix.")
    public Value<Double[][]> apply() {
        Value numStates = this.getParams().get(numStatesParamName);
        Value rateValue = this.getParams().get("meanRate");
        double rate = rateValue != null ? ValueUtils.doubleValue(rateValue) : 1.0;
        return new DoubleArray2DValue(LewisMK.jc(rate, (Integer)numStates.value()), (DeterministicFunction)this);
    }

    static Double[][] jc(Double meanRate, int numStates) {
        Double[][] Q = new Double[numStates][numStates];
        for (int i = 0; i < numStates; ++i) {
            for (int j = 0; j < numStates; ++j) {
                if (i != j) {
                    Q[i][j] = 1.0 / ((double)numStates - 1.0) * meanRate;
                    continue;
                }
                Q[i][i] = -1.0 * meanRate;
            }
        }
        return Q;
    }

    public Value<Integer> getNumStates() {
        return this.getParams().get(numStatesParamName);
    }
}

