/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.substitutionmodel;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public abstract class RateMatrix
extends DeterministicFunction<Double[][]> {
    public static final String meanRateParamName = "meanRate";

    public RateMatrix(@ParameterInfo(name="meanRate", description="the mean rate of the process. Default value is 1.0.", optional=true) Value<Number> rate) {
        if (rate != null) {
            this.setParam(meanRateParamName, (Value)rate);
        }
    }

    void normalize(Double[] freqs, Double[][] Q) {
        this.normalize(freqs, Q, this.totalRateDefault1());
    }

    protected void normalize(Double[] freqs, Double[][] Q, double rate) {
        int i;
        double subst = 0.0;
        for (i = 0; i < Q.length; ++i) {
            subst += -Q[i][i].doubleValue() * freqs[i];
        }
        for (i = 0; i < Q.length; ++i) {
            for (int j = 0; j < Q.length; ++j) {
                Q[i][j] = rate * (Q[i][j] / subst);
            }
        }
    }

    Double[][] normalize(double[] freqs, double[][] Q, double rate) {
        int i;
        Double[][] Qn = new Double[Q.length][Q.length];
        double subst = 0.0;
        for (i = 0; i < Q.length; ++i) {
            subst += -Q[i][i] * freqs[i];
        }
        for (i = 0; i < Q.length; ++i) {
            for (int j = 0; j < Q.length; ++j) {
                Qn[i][j] = rate * (Q[i][j] / subst);
            }
        }
        return Qn;
    }

    public double totalRateDefault1() {
        Value<Double> meanRate = this.getMeanRate();
        if (meanRate != null) {
            return meanRate.value();
        }
        return 1.0;
    }

    public Value<Double> getMeanRate() {
        return this.getParams().get(meanRateParamName);
    }

    public static void main(String ... args) throws ClassNotFoundException {
        Constructor<?> constructor = RateMatrix.class.getConstructors()[0];
        System.out.println("Generic parameter types");
        Type[] generics = constructor.getGenericParameterTypes();
        for (int i = 0; i < generics.length; ++i) {
            String name = generics[i].getTypeName();
            System.out.println("name=" + name);
            System.out.println("class=" + Class.forName(name.substring(name.indexOf(60) + 1, name.indexOf(62))));
        }
        System.out.println("Type variables");
        TypeVariable<Constructor<?>>[] typeVariables = constructor.getTypeParameters();
        for (int i = 0; i < typeVariables.length; ++i) {
            System.out.println("name=" + typeVariables[i].getName());
        }
    }
}

