/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.substitutionmodel;

import lphy.evolution.substitutionmodel.RateMatrix;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleArray2DValue;

public class TN93
extends RateMatrix {
    public static final String kappa1ParamName = "kappa1";
    public static final String kappa2ParamName = "kappa2";
    public static final String freqParamName = "freq";

    public TN93(@ParameterInfo(name="kappa1", description="the rate of A<->G transition in the TN93 process.") Value<Double> kappa1, @ParameterInfo(name="kappa2", description="the rate of C<->T transition in the TN93 process.") Value<Double> kappa2, @ParameterInfo(name="freq", description="the base frequencies.") Value<Double[]> freq, @ParameterInfo(name="meanRate", description="the mean rate of the process. default 1.0", optional=true) Value<Number> meanRate) {
        super(meanRate);
        this.setParam(kappa1ParamName, (Value)kappa1);
        this.setParam(kappa2ParamName, (Value)kappa2);
        this.setParam(freqParamName, (Value)freq);
    }

    @Override
    @GeneratorInfo(name="tn93", description="The TN93 instantaneous rate matrix. Takes kappa1, kappa2 and base frequencies and produces an Tamura-Nei-93 rate matrix.")
    public Value<Double[][]> apply() {
        Value<Double> kappa1 = this.getKappa1();
        Value<Double> kappa2 = this.getKappa2();
        Value freq = this.getParams().get(freqParamName);
        return new DoubleArray2DValue(this.getName() + "(" + kappa1.getLabel() + ", " + kappa2.getLabel() + ", " + freq.getLabel() + ")", this.hky(kappa1.value(), kappa2.value(), (Double[])freq.value()), (DeterministicFunction)this);
    }

    private Double[][] hky(double kappa1, double kappa2, Double[] freqs) {
        int numStates = 4;
        Double[][] Q = new Double[][]{{0.0, freqs[1], freqs[2] * kappa1, freqs[3]}, {freqs[0], 0.0, freqs[2], freqs[3] * kappa2}, {freqs[0] * kappa1, freqs[1], 0.0, freqs[3]}, {freqs[0], freqs[1] * kappa2, freqs[2], 0.0}};
        double[] totalRates = new double[numStates];
        for (int i = 0; i < numStates; ++i) {
            for (int j = 0; j < numStates; ++j) {
                int n = i;
                totalRates[n] = totalRates[n] + Q[i][j];
            }
        }
        this.normalize(freqs, Q);
        return Q;
    }

    public Value<Double> getKappa1() {
        return this.getParams().get(kappa1ParamName);
    }

    public Value<Double> getKappa2() {
        return this.getParams().get(kappa2ParamName);
    }

    public Value<Double[]> getFreq() {
        return this.getParams().get(freqParamName);
    }
}

