/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.substitutionmodel;

import java.util.stream.Stream;
import lphy.evolution.substitutionmodel.RateMatrix;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleArray2DValue;

public class WAG
extends RateMatrix {
    public static final String freqParamName = "freq";

    public WAG(@ParameterInfo(name="freq", description="the base frequencies.", optional=true) Value<Double[]> freq, @ParameterInfo(name="meanRate", description="the mean rate of the process. default 1.0", optional=true) Value<Number> meanRate) {
        super(meanRate);
        if (freq != null) {
            if (freq.value().length != 20) {
                throw new IllegalArgumentException("Amino acid frequencies must have 20 dimensions.");
            }
            this.setParam(freqParamName, (Value)freq);
        }
    }

    @Override
    @GeneratorInfo(name="wag", description="The WAG instantaneous rate matrix for amino acid.")
    public Value<Double[][]> apply() {
        Value freq = this.getParams().get(freqParamName);
        Double[][] Q = freq != null ? this.getQ((Double[])freq.value()) : this.getQ(null);
        return new DoubleArray2DValue(Q, (DeterministicFunction)this);
    }

    protected Double[][] getQ(Double[] freqs) {
        double[] f = freqs != null ? Stream.of(freqs).mapToDouble(Double::doubleValue).toArray() : jebl.evolution.substmodel.WAG.getOriginalFrequencies();
        jebl.evolution.substmodel.WAG wag = new jebl.evolution.substmodel.WAG(f);
        double totalRate = wag.setParametersNoScale(null);
        double[][] Q = wag.getRelativeRates();
        return this.normalize(f, Q, this.totalRateDefault1());
    }

    public GraphicalModelNode<?> getFreq() {
        return this.getParams().get(freqParamName);
    }
}

