/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class CharSetBlock {
    private final int from;
    private final int to;
    private final int every;

    public CharSetBlock(int from, int to, int every) {
        this.from = from;
        this.to = to;
        this.every = every;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int getEvery() {
        return this.every;
    }

    public String toString() {
        return "CharSet{from=" + this.from + ", to=" + this.to + ", every=" + this.every + "}";
    }

    public static class Utils {
        private static final String CHARSET_REGX = "^([0-9]+)$|^([0-9]+)\\-([0-9]+)(\\\\[0-9]+)*$|^([0-9]+)\\-(\\.)(\\\\[0-9]+)*$";

        public static boolean isValid(String str) {
            return Pattern.matches(CHARSET_REGX, str);
        }

        public static List<CharSetBlock> getCharSetBlocks(String expression) {
            String[] blocks = expression.split("\\s+");
            ArrayList<CharSetBlock> charSetBlocks = new ArrayList<CharSetBlock>();
            for (String oneBlock : blocks) {
                CharSetBlock charSetBlock = Utils.parseCharSet(oneBlock);
                charSetBlocks.add(charSetBlock);
            }
            return charSetBlocks;
        }

        public static CharSetBlock parseCharSet(String charSet1Block) throws IllegalArgumentException {
            int to;
            int from;
            int every;
            block6: {
                if (!Utils.isValid(Objects.requireNonNull(charSet1Block))) {
                    throw new IllegalArgumentException("Invalid charset expression " + charSet1Block);
                }
                String[] parts = charSet1Block.split("-");
                every = 1;
                try {
                    if (parts.length == 2) {
                        from = Integer.parseInt(parts[0].trim());
                        if (parts[1].contains("/")) {
                            throw new IllegalArgumentException("Invalid delimiter for codon positions ! " + parts[1]);
                        }
                        String[] toParts = parts[1].split("\\\\");
                        to = toParts[0].trim().equals(".") ? -1 : Integer.parseInt(toParts[0].trim());
                        every = toParts.length > 1 ? Integer.parseInt(toParts[1].trim()) : 1;
                        break block6;
                    }
                    if (parts.length == 1) {
                        to = from = Integer.parseInt(parts[0].trim());
                        break block6;
                    }
                    throw new NumberFormatException();
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("block " + charSet1Block + " cannot be parsed");
                }
            }
            return new CharSetBlock(from, to, every);
        }
    }
}

