/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.tree;

import java.util.ArrayList;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.evolution.tree.TimeTreeUtils;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class ExtantTree
extends DeterministicFunction<TimeTree> {
    public ExtantTree(@ParameterInfo(name="tree", description="the full tree to extract extant tree from.") Value<TimeTree> tree) {
        this.setParam("tree", (Value)tree);
    }

    @Override
    @GeneratorInfo(name="extantTree", description="A tree pruned from a larger tree by retaining only the tips at time zero.")
    public Value<TimeTree> apply() {
        Value tree = this.getParams().get("tree");
        TimeTree extantTree = new TimeTree((TimeTree)tree.value());
        ArrayList<TimeTreeNode> sampleTips = new ArrayList<TimeTreeNode>();
        while (sampleTips.size() == 0) {
            for (TimeTreeNode node : extantTree.getNodes()) {
                if (!node.isLeaf() || node.getAge() != 0.0) continue;
                sampleTips.add(node);
            }
        }
        for (TimeTreeNode tip : sampleTips) {
            TimeTreeUtils.markNodeAndDirectAncestors(tip);
        }
        TimeTreeUtils.removeUnmarkedNodes(extantTree);
        TimeTreeNode newRoot = TimeTreeUtils.getFirstNonSingleChildNode(extantTree);
        if (!newRoot.isRoot()) {
            newRoot.getParent().removeChild(newRoot);
        }
        TimeTreeUtils.removeSingleChildNodes(newRoot, false);
        extantTree.setRoot(newRoot, true);
        return new Value<TimeTree>(null, extantTree, this);
    }
}

