/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.tree;

import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.evolution.tree.TimeTreeUtils;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public class PruneTree
extends DeterministicFunction<TimeTree> {
    public PruneTree(@ParameterInfo(name="tree", description="the full tree to sample") Value<TimeTree> tree) {
        this.setParam("tree", (Value)tree);
    }

    @Override
    @GeneratorInfo(name="pruneTree", description="A tree pruned from a larger tree by retaining only nodes subtending nodes with non-null id's.")
    public Value<TimeTree> apply() {
        Value tree = this.getParams().get("tree");
        TimeTree prunedTree = new TimeTree((TimeTree)tree.value());
        for (TimeTreeNode node : prunedTree.getNodes()) {
            if (node.getId() == null) continue;
            TimeTreeUtils.markNodeAndDirectAncestors(node);
        }
        TimeTreeUtils.removeUnmarkedNodes(prunedTree);
        TimeTreeUtils.removeSingleChildNodes(prunedTree, true);
        prunedTree.setRoot(prunedTree.getRoot(), true);
        TimeTreeUtils.removeMarks(prunedTree);
        return new Value<TimeTree>(null, prunedTree, this);
    }
}

