/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lphy.evolution.Taxa;
import lphy.evolution.Taxon;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.random.RandomGenerator;

public abstract class TaxaConditionedTreeGenerator
implements GenerativeDistribution<TimeTree> {
    public static final String taxaParamName = "taxa";
    public static final String agesParamName = "ages";
    protected Value<Integer> n;
    protected Value taxaValue;
    protected Value<Double[]> ages;
    private Taxa taxa;
    private boolean taxaConstructed = false;
    protected RandomGenerator random;

    public TaxaConditionedTreeGenerator(Value<Integer> n, Value taxaValue, Value<Double[]> ages) {
        this.n = n;
        this.taxaValue = taxaValue;
        this.ages = ages;
    }

    protected void checkTaxaParameters(boolean atLeastOneRequired) {
        if (atLeastOneRequired && this.taxaValue == null && this.n == null && this.ages == null) {
            throw new IllegalArgumentException("At least one of n, taxa, ages must be specified.");
        }
        if (this.taxaValue != null && this.n != null && this.getTaxa().ntaxa() != this.n.value().intValue()) {
            throw new IllegalArgumentException("n and taxa values are incompatible.");
        }
        if (this.ages != null && this.n != null && this.ages.value().length != this.n.value()) {
            throw new IllegalArgumentException("n and ages values are incompatible.");
        }
        if (this.ages != null && this.taxaValue != null) {
            throw new IllegalArgumentException("Only one of taxa and ages may be specified.");
        }
    }

    private void constructTaxa() {
        if (this.taxaValue == null) {
            this.taxa = this.ages != null ? Taxa.createTaxa(this.ages.value()) : Taxa.createTaxa(this.n());
        } else if (this.taxaValue.value() instanceof Taxa) {
            this.taxa = (Taxa)this.taxaValue.value();
        } else if (this.taxaValue.value().getClass().isArray()) {
            this.taxa = this.taxaValue.value() instanceof Taxon[] ? Taxa.createTaxa((Taxon[])this.taxaValue.value()) : Taxa.createTaxa((Object[])this.taxaValue.value());
        } else {
            throw new IllegalArgumentException("taxa must be of type Object[] or Taxa, but it is type " + this.taxaValue.value().getClass());
        }
        this.taxaConstructed = true;
    }

    public Taxa getTaxa() {
        if (!this.taxaConstructed) {
            this.constructTaxa();
        }
        return this.taxa;
    }

    protected int n() {
        if (this.n != null) {
            return this.n.value();
        }
        return this.getTaxa().ntaxa();
    }

    protected void createLeafNodes(TimeTree tree, List<TimeTreeNode> nodeList) {
        if (!this.taxaConstructed) {
            this.constructTaxa();
        }
        String[] names = this.taxa.getTaxaNames();
        Double[] ages = this.taxa.getAges();
        for (int i = 0; i < names.length; ++i) {
            TimeTreeNode node = new TimeTreeNode(names[i], tree);
            node.setAge(ages[i]);
            node.setLeafIndex(i);
            nodeList.add(node);
        }
    }

    protected List<TimeTreeNode> createLeafTaxa(TimeTree tree) {
        ArrayList<TimeTreeNode> leafNodes = new ArrayList<TimeTreeNode>();
        this.createLeafNodes(tree, leafNodes);
        return leafNodes;
    }

    protected TimeTreeNode drawRandomNode(List<TimeTreeNode> nodeList) {
        return nodeList.remove(this.random.nextInt(nodeList.size()));
    }

    protected TimeTreeNode drawRandomNodeWithReplacement(List<TimeTreeNode> nodeList) {
        return nodeList.get(this.random.nextInt(nodeList.size()));
    }

    @Override
    public Map<String, Value> getParams() {
        TreeMap<String, Value> map = new TreeMap<String, Value>();
        if (this.n != null) {
            map.put("n", this.n);
        }
        if (this.taxaValue != null) {
            map.put(taxaParamName, this.taxaValue);
        }
        if (this.ages != null) {
            map.put(agesParamName, this.ages);
        }
        return map;
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "n": {
                this.n = value;
                break;
            }
            case "taxa": {
                this.taxaValue = value;
                break;
            }
            case "ages": {
                this.ages = value;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised parameter name: " + paramName);
            }
        }
        this.constructTaxa();
    }

    public String toString() {
        return this.getName();
    }
}

