/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.tree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import lphy.evolution.HasTaxa;
import lphy.evolution.Taxa;
import lphy.evolution.tree.TimeTreeNode;
import lphy.graphicalModel.MethodInfo;
import lphy.graphicalModel.MultiDimensional;

public class TimeTree
implements HasTaxa,
MultiDimensional {
    TimeTreeNode rootNode;
    private List<TimeTreeNode> nodes;
    Taxa taxa = null;
    boolean constructedWithTaxa = false;
    int n = 0;

    public TimeTree(Taxa taxa) {
        this.taxa = taxa;
        this.constructedWithTaxa = true;
    }

    public TimeTree() {
    }

    public TimeTree(TimeTree treeToCopy) {
        this.taxa = treeToCopy.taxa;
        this.setRoot(treeToCopy.getRoot().deepCopy(this));
    }

    public void setRoot(TimeTreeNode root, boolean reindexLeaves) {
        this.rootNode = root;
        this.rootNode.setParent(null);
        this.rootNode.tree = this;
        this.nodes = new ArrayList<TimeTreeNode>();
        this.fillNodeList(this.rootNode, reindexLeaves);
        this.indexNodes(this.rootNode, new int[]{this.n});
        this.nodes.sort(Comparator.comparingInt(TimeTreeNode::getIndex));
        if (!this.constructedWithTaxa) {
            this.taxa = Taxa.createTaxa(root);
        }
    }

    public void setRoot(TimeTreeNode root) {
        this.setRoot(root, false);
    }

    private void indexNodes(TimeTreeNode node, int[] nextInternalIndex) {
        if (node.isLeaf()) {
            node.setIndex(node.getLeafIndex());
        } else {
            for (TimeTreeNode child : node.getChildren()) {
                this.indexNodes(child, nextInternalIndex);
            }
            node.setIndex(nextInternalIndex[0]);
            nextInternalIndex[0] = nextInternalIndex[0] + 1;
        }
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getSingleChildNodeCount() {
        int count = 0;
        for (TimeTreeNode node : this.nodes) {
            if (node.getChildCount() != 1) continue;
            ++count;
        }
        return count;
    }

    public List<TimeTreeNode> getNodes() {
        return this.nodes;
    }

    private int fillNodeList(TimeTreeNode node, boolean reindexLeaves) {
        if (node.isRoot()) {
            this.nodes.clear();
            this.n = 0;
        }
        node.tree = this;
        if (node.getMetaData("remove") != null) {
            throw new RuntimeException("A node that should be removed has not been!" + node.id);
        }
        if (node.isLeaf()) {
            this.nodes.add(node);
            if (node.getLeafIndex() == -1 || reindexLeaves) {
                node.setLeafIndex(this.n);
            }
            ++this.n;
        } else {
            for (TimeTreeNode child : node.getChildren()) {
                this.fillNodeList(child, reindexLeaves);
            }
            this.nodes.add(node);
        }
        return this.nodes.size();
    }

    public int n() {
        return this.n;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toNewick(this.rootNode, builder, true);
        return builder.toString();
    }

    private void toNewick(TimeTreeNode node, StringBuilder builder, boolean includeSingleChildNodes) {
        if (!includeSingleChildNodes && node.getChildCount() == 1) {
            this.toNewick(node.getChildren().get(0), builder, includeSingleChildNodes);
        } else {
            if (node.isLeaf()) {
                builder.append(node.id);
                SortedMap<String, Object> metaData = node.metaData;
                if (metaData.size() > 0) {
                    builder.append("[&");
                    for (Map.Entry<String, Object> entry : metaData.entrySet()) {
                        builder.append(entry.getKey());
                        builder.append("=");
                        builder.append(entry.getValue());
                    }
                    builder.append("]");
                }
            } else {
                builder.append("(");
                List<TimeTreeNode> children = node.getChildren();
                this.toNewick(children.get(0), builder, includeSingleChildNodes);
                for (int i = 1; i < children.size(); ++i) {
                    builder.append(",");
                    this.toNewick(children.get(i), builder, includeSingleChildNodes);
                }
                builder.append(")");
            }
            if (node.isRoot()) {
                builder.append(":0.0;");
            } else {
                builder.append(":");
                double branchLength = this.getBranchLength(node, includeSingleChildNodes);
                builder.append(branchLength);
            }
        }
    }

    private double getBranchLength(TimeTreeNode node, boolean includeSingleChildNodes) {
        TimeTreeNode parent = node.getParent();
        if (!includeSingleChildNodes && parent.getChildCount() == 1) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return parent.age - node.age;
        }
        return 0.0;
    }

    public TimeTreeNode getRoot() {
        return this.rootNode;
    }

    public String[] getTaxaNames() {
        return this.taxa.getTaxaNames();
    }

    public String[] getSpecies() {
        return this.taxa.getSpecies();
    }

    public TimeTreeNode getNodeByIndex(int index) {
        TimeTreeNode node = this.getNodes().get(index);
        if (node.getIndex() != index) {
            throw new RuntimeException();
        }
        return node;
    }

    public boolean isUltrametric() {
        for (TimeTreeNode node : this.getNodes()) {
            if (!node.isLeaf() || node.getAge() == 0.0) continue;
            return false;
        }
        return true;
    }

    public String toNewick(boolean includeSingleChildNodes) {
        StringBuilder builder = new StringBuilder();
        this.toNewick(this.rootNode, builder, includeSingleChildNodes);
        return builder.toString();
    }

    @Override
    public int getDimension() {
        return this.n();
    }

    @Override
    public Taxa getTaxa() {
        return this.taxa;
    }

    public List<TimeTreeNode> getExtantNodes() {
        return this.getNodes().stream().filter(TimeTreeNode::isExtant).collect(Collectors.toList());
    }

    @MethodInfo(description="the total length of the tree")
    public Double treeLength() {
        double TL = 0.0;
        for (TimeTreeNode node : this.getNodes()) {
            if (node.isRoot()) continue;
            TL += node.getParent().age - node.age;
        }
        return TL;
    }

    @MethodInfo(description="the age of the root of the tree.")
    public Double rootAge() {
        return this.getRoot().age;
    }

    @MethodInfo(description="the total number of nodes in the tree (both leaf nodes and internal nodes).")
    public Integer nodeCount() {
        return this.getNodeCount();
    }

    @MethodInfo(description="the total number of extant leaves in the tree (leaf nodes with age 0.0).")
    public Integer extantCount() {
        int count = 0;
        for (TimeTreeNode node : this.getNodes()) {
            if (node.age != 0.0 || !node.isLeaf()) continue;
            ++count;
        }
        return count;
    }

    @MethodInfo(description="the total number of leaf nodes in the tree (leaf nodes with any age, but excluding zero-branch-length leaf nodes, which are logically direct ancestors).")
    public Integer leafCount() {
        int count = 0;
        for (TimeTreeNode node : this.getNodes()) {
            if (!node.isLeaf() || node.isDirectAncestor()) continue;
            ++count;
        }
        return count;
    }

    @MethodInfo(description="the total number of nodes in the tree that are direct ancestors (i.e. have a single parent and a single child, or have one child that is a zero-branch-length leaf).")
    public Integer directAncestorCount() {
        int count = 0;
        for (TimeTreeNode node : this.getNodes()) {
            if (!node.isDirectAncestor()) continue;
            ++count;
        }
        return count;
    }

    @MethodInfo(description="the taxa of the tree.")
    public Taxa taxa() {
        return this.getTaxa();
    }

    @MethodInfo(description="returns true if this tree has an origin node (defined as a root node with a single child.")
    public boolean hasOrigin() {
        return this.getRoot().isOrigin();
    }
}

