/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import lphy.evolution.Taxon;
import lphy.evolution.tree.TimeTree;

public class TimeTreeNode {
    private ArrayList<TimeTreeNode> children = new ArrayList();
    private TimeTreeNode parent = null;
    private int index;
    private int leafIndex = -1;
    double age = 0.0;
    String id = null;
    private static final double zeroBranchLengthTolerance = 1.0E-15;
    SortedMap<String, Object> metaData = new TreeMap<String, Object>();
    TimeTree tree;

    public TimeTreeNode(String id, TimeTree tree) {
        this.id = id;
        this.tree = tree;
        this.age = 0.0;
    }

    public TimeTreeNode(double age) {
        this.age = age;
    }

    public TimeTreeNode(double age, TimeTreeNode[] children) {
        this.age = age;
        this.children = new ArrayList();
        Collections.addAll(this.children, children);
        for (TimeTreeNode child : children) {
            child.parent = this;
        }
    }

    public TimeTreeNode(Taxon taxon, TimeTree tree) {
        this.age = taxon.getAge();
        this.id = taxon.getName();
        this.tree = tree;
    }

    TimeTreeNode deepCopy(TimeTree tree) {
        TimeTreeNode copy = new TimeTreeNode(this.id, tree);
        copy.id = this.id;
        copy.index = this.index;
        copy.age = this.age;
        copy.leafIndex = this.leafIndex;
        for (TimeTreeNode child : this.children) {
            copy.addChild(child.deepCopy(tree));
        }
        return copy;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isOrigin() {
        return this.parent == null && this.getChildCount() == 1;
    }

    public boolean isSingleChildNonOrigin() {
        return this.parent != null && this.getChildCount() == 1;
    }

    public boolean isDirectAncestor() {
        return this.isSingleChildNonOrigin() || this.isLeaf() && this.getParent().age - this.age <= 1.0E-15;
    }

    public final boolean isLeaf() {
        return this.children == null || this.children.size() == 0;
    }

    public final double getAge() {
        return this.age;
    }

    public List<TimeTreeNode> getChildren() {
        return this.children;
    }

    public final String getId() {
        return this.id;
    }

    public void setBranchRate(Double rate) {
        this.setMetaData("rate", rate);
    }

    public Double getBranchRate() {
        return (Double)this.getMetaData("rate");
    }

    public void setMetaData(String key, Object value) {
        this.metaData.put(key, value);
    }

    public Object getMetaData(String key) {
        return this.metaData.get(key);
    }

    public void removeMetaData(String key) {
        this.metaData.remove(key);
    }

    public SortedMap<String, Object> getMetaData() {
        return this.metaData;
    }

    public TimeTreeNode getParent() {
        return this.parent;
    }

    public void setParent(TimeTreeNode newParent) {
        this.parent = newParent;
    }

    public String toString() {
        if (this.isLeaf()) {
            return this.getId();
        }
        return super.toString();
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int index) {
        this.index = index;
    }

    public final int getLeafIndex() {
        return this.leafIndex;
    }

    public final void setLeafIndex(int index) {
        this.leafIndex = index;
    }

    public void addChild(TimeTreeNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        if (child != null) {
            child.parent = this;
        }
    }

    public void removeChild(TimeTreeNode child) {
        child.parent = null;
        this.children.remove(child);
    }

    public final void setAge(double age) {
        this.age = age;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public List<TimeTreeNode> getAllLeafNodes() {
        ArrayList<TimeTreeNode> leafNodes = new ArrayList<TimeTreeNode>();
        if (!this.isLeaf()) {
            this.getAllLeafNodes(leafNodes);
        }
        return leafNodes;
    }

    public void getAllLeafNodes(List<TimeTreeNode> leafNodes) {
        if (this.isLeaf()) {
            leafNodes.add(this);
        }
        if (!this.isLeaf()) {
            for (TimeTreeNode child : this.children) {
                child.getAllLeafNodes(leafNodes);
            }
        }
    }

    public void sort() {
        if (!this.isLeaf()) {
            for (TimeTreeNode child : this.children) {
                child.sort();
            }
            this.children.sort(Comparator.comparingInt(o -> o.index));
        }
    }

    public int getTotalDescendantNodeCount() {
        if (this.isLeaf()) {
            return 1;
        }
        int count = 1;
        for (TimeTreeNode child : this.getChildren()) {
            count += child.getTotalDescendantNodeCount();
        }
        return count;
    }

    public TimeTreeNode getChild(int i) {
        if (this.index >= 0 && i < this.children.size()) {
            return this.children.get(i);
        }
        return null;
    }

    public TimeTreeNode getLeft() {
        if (!this.isLeaf()) {
            return this.children.get(0);
        }
        return null;
    }

    public TimeTreeNode getRight() {
        if (!this.isLeaf()) {
            return this.children.get(1);
        }
        return null;
    }

    public void setLeft(TimeTreeNode left) {
        if (this.children.size() > 0) {
            this.children.set(0, left);
            left.setParent(this);
        } else {
            this.addChild(left);
        }
    }

    public void setRight(TimeTreeNode right) {
        if (this.children.size() > 1) {
            this.children.set(1, right);
        } else {
            if (this.children.size() < 1) {
                this.addChild(null);
            }
            this.children.add(right);
        }
        right.setParent(this);
    }

    public int countLeaves() {
        if (this.isLeaf()) {
            return 1;
        }
        int leafCount = 0;
        for (TimeTreeNode child : this.getChildren()) {
            leafCount += child.countLeaves();
        }
        return leafCount;
    }

    public double getBranchDuration() {
        if (!this.isRoot()) {
            return this.getParent().age - this.age;
        }
        return 0.0;
    }

    public boolean isExtant() {
        return this.isLeaf() && this.age == 0.0;
    }
}

