/*
 * Decompiled with CFR 0.152.
 */
package lphy.evolution.tree;

import java.util.ArrayList;
import lphy.evolution.tree.TimeTree;
import lphy.evolution.tree.TimeTreeNode;

public class TimeTreeUtils {
    private static String markLabel = "mark";

    public static TimeTreeNode getFirstNonSingleChildNode(TimeTree tree) {
        return TimeTreeUtils.getFirstNonSingleChildNode(tree.getRoot());
    }

    private static TimeTreeNode getFirstNonSingleChildNode(TimeTreeNode node) {
        if (node.getChildCount() != 1) {
            return node;
        }
        return TimeTreeUtils.getFirstNonSingleChildNode(node.getChildren().get(0));
    }

    public static void removeSingleChildNodes(TimeTree tree) {
        TimeTreeUtils.removeSingleChildNodes(tree, false);
    }

    public static void removeSingleChildNodes(TimeTree tree, boolean onlyAnonymous) {
        TimeTreeUtils.removeSingleChildNodes(tree.getRoot(), onlyAnonymous);
    }

    public static void removeSingleChildNodes(TimeTreeNode node, boolean onlyAnonymous) {
        if (node.isSingleChildNonOrigin() && (!onlyAnonymous || node.getId() == null)) {
            TimeTreeNode grandChild = node.getChildren().get(0);
            TimeTreeNode parent = node.getParent();
            parent.removeChild(node);
            node.removeChild(grandChild);
            parent.addChild(grandChild);
            TimeTreeUtils.removeSingleChildNodes(grandChild, onlyAnonymous);
        } else {
            ArrayList<TimeTreeNode> copy = new ArrayList<TimeTreeNode>();
            copy.addAll(node.getChildren());
            for (TimeTreeNode child : copy) {
                TimeTreeUtils.removeSingleChildNodes(child, onlyAnonymous);
            }
        }
    }

    public static void removeUnmarkedNodes(TimeTree tree) {
        TimeTreeUtils.removeUnmarkedNodes(tree.getRoot());
    }

    private static void removeUnmarkedNodes(TimeTreeNode node) {
        if (!TimeTreeUtils.isMarked(node)) {
            if (node.isRoot()) {
                throw new RuntimeException("Root should always be marked! Something is very wrong!");
            }
            node.getParent().removeChild(node);
        } else if (!node.isLeaf()) {
            ArrayList<TimeTreeNode> copy = new ArrayList<TimeTreeNode>();
            copy.addAll(node.getChildren());
            for (TimeTreeNode child : copy) {
                TimeTreeUtils.removeUnmarkedNodes(child);
            }
        }
    }

    private static boolean isMarked(TimeTreeNode node) {
        Object markObject = node.getMetaData(markLabel);
        return markObject != null;
    }

    public static void markNodeAndDirectAncestors(TimeTreeNode node) {
        if (node != null) {
            node.setMetaData(markLabel, true);
            TimeTreeUtils.markNodeAndDirectAncestors(node.getParent());
        }
    }

    public static void removeMarks(TimeTree tree) {
        TimeTreeUtils.removeMarks(tree.getRoot());
    }

    public static void removeMarks(TimeTreeNode node) {
        node.removeMetaData(markLabel);
        for (TimeTreeNode child : node.getChildren()) {
            TimeTreeUtils.removeMarks(child);
        }
    }
}

